/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.ActivityTaskCreationListener;
import org.exoplatform.task.integration.ActivityTaskProcessor;
import org.junit.Assert;
import org.junit.Test;

public class TestSyntaxTaskFromActivity {
    @Test
    public void testExtractTaskInfo() {
        ActivityTaskCreationListener processor = new ActivityTaskCreationListener(null, null, null, null, null, null, null, null);
        String html = "we need to ++download new documentation from cloud<br>It helps you understand better what's happening";
        TaskDto taskInfo = processor.extractTaskInfo(html);
        Assert.assertEquals((Object)"download new documentation from cloud", (Object)taskInfo.getTitle());
        Assert.assertEquals((Object)"It helps you understand better what's happening", (Object)taskInfo.getDescription());
        html = "we need to ++download new <strong>documentation from <i>cloud<br>It helps you</i> understand</strong> better what's happening";
        taskInfo = processor.extractTaskInfo(html);
        Assert.assertEquals((Object)"download new documentation from cloud", (Object)taskInfo.getTitle());
        Assert.assertEquals((Object)"It helps you</i> understand</strong> better what's happening", (Object)taskInfo.getDescription());
        html = "we need to ++download new <strong>documentation from cloud<br>It helps you understand</strong> better what's happening";
        taskInfo = processor.extractTaskInfo(html);
        Assert.assertEquals((Object)"download new documentation from cloud", (Object)taskInfo.getTitle());
        Assert.assertEquals((Object)"It helps you understand</strong> better what's happening", (Object)taskInfo.getDescription());
    }

    @Test
    public void testSubstituteTask() {
        ActivityTaskProcessor processor = new ActivityTaskProcessor(null, null, null, null);
        String taskURL = "/link/to/task";
        String html = "we need to ++download new documentation from cloud<br>It helps you understand better what's happening";
        String expected = "we need to <a href=\"/link/to/task\">++download new documentation from cloud</a><br>It helps you understand better what's happening";
        Assert.assertEquals((Object)expected, (Object)processor.substituteTask(taskURL, html));
        html = "we need to ++download new <strong>documentation from cloud<br>It helps you understand</strong> better what's happening";
        expected = "we need to <a href=\"/link/to/task\">++download new </a><strong>documentation from cloud<br>It helps you understand</strong> better what's happening";
        Assert.assertEquals((Object)expected, (Object)processor.substituteTask(taskURL, html));
    }
}

