/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.util.Date;
import java.util.HashSet;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.dto.UserSettingDto;
import org.exoplatform.task.model.User;

public class TestUtils {
    public static long EXISTING_TASK_ID = 1L;
    public static long UNEXISTING_TASK_ID = 2L;
    public static long EXISTING_PROJECT_ID = 1L;
    public static long UNEXISTING_PROJECT_ID = 2L;
    public static long EXISTING_STATUS_ID = 1L;
    public static long UNEXISTING_STATUS_ID = 2L;
    public static long EXISTING_COMMENT_ID = 1L;
    public static long UNEXISTING_COMMENT_ID = 2L;
    public static long EXISTING_LABEL_ID = 1L;
    public static long UNEXISTING_LABEL_ID = 2L;

    public static Task getDefaultTask() {
        return TestUtils.getDefaultTaskWithId(EXISTING_TASK_ID);
    }

    public static TaskDto getDefaultTaskDto() {
        return TestUtils.getDefaultTaskDtoWithId(EXISTING_TASK_ID);
    }

    public static Task getDefaultTaskWithId(long id) {
        Task task = new Task();
        task.setId(id);
        task.setTitle("Default task");
        task.setAssignee("root");
        task.setCreatedBy("root");
        task.setCreatedTime(new Date());
        return task;
    }

    public static TaskDto getDefaultTaskDtoWithId(long id) {
        TaskDto task = new TaskDto();
        task.setId(id);
        task.setTitle("Default task");
        task.setAssignee("root");
        task.setCreatedBy("root");
        task.setCreatedTime(new Date());
        return task;
    }

    public static Comment getDefaultComment() {
        Comment comment = new Comment();
        comment.setId(EXISTING_COMMENT_ID);
        comment.setComment("Bla bla");
        comment.setAuthor("Tib");
        comment.setCreatedTime(new Date());
        comment.setTask(TestUtils.getDefaultTask());
        return comment;
    }

    public static Comment getDefaultCommentWithMention() {
        Comment comment = new Comment();
        comment.setId(EXISTING_COMMENT_ID);
        comment.setComment("Bla bla @testa");
        comment.setAuthor("Tib");
        comment.setCreatedTime(new Date());
        comment.setTask(TestUtils.getDefaultTask());
        return comment;
    }

    public static CommentDto getDefaultCommentDto() {
        CommentDto comment = new CommentDto();
        comment.setId(EXISTING_COMMENT_ID);
        comment.setComment("Bla bla");
        comment.setAuthor("Tib");
        comment.setCreatedTime(new Date());
        comment.setTask(TestUtils.getDefaultTaskDto());
        return comment;
    }

    public static Status getDefaultStatus() {
        Status status = new Status();
        status.setId(EXISTING_STATUS_ID);
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        return status;
    }

    public static StatusDto getDefaultStatusDto() {
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(EXISTING_STATUS_ID));
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        return status;
    }

    public static UserSettingDto getDefaultUserSettingDto() {
        UserSettingDto userSettingDto = new UserSettingDto();
        userSettingDto.setUsername("user");
        userSettingDto.setShowHiddenProject(true);
        userSettingDto.setShowHiddenLabel(true);
        return userSettingDto;
    }

    public static LabelDto getDefaultLabel() {
        LabelDto labelDto = new LabelDto();
        labelDto.setId(EXISTING_LABEL_ID);
        labelDto.setName("TODO");
        labelDto.setUsername("label");
        return labelDto;
    }

    public static Project getDefaultProject() {
        Project project = new Project();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }

    public static ProjectDto getDefaultProjectDto() {
        ProjectDto project = new ProjectDto();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }

    public static User getUser() {
        User user = new User();
        user.setUsername("root");
        user.setDisplayName("root");
        user.setFirstName("root");
        user.setLastName("root");
        user.setEmail("root@gmail.com");
        return user;
    }

    public static User getUserA() {
        User user = new User();
        user.setUsername("userA");
        user.setDisplayName("userA");
        user.setFirstName("userA");
        user.setLastName("userA");
        user.setEmail("userA@gmail.com");
        return user;
    }

    public static Identity getUserAIdentity() {
        Identity userIdentity = new Identity("organization", "userA");
        userIdentity.setEnable(true);
        userIdentity.setDeleted(false);
        userIdentity.setRemoteId("userA");
        Profile userProfile = new Profile(userIdentity);
        userProfile.setProperty("fullName", (Object)"userA");
        userProfile.setProperty("avatar", (Object)"/userA.png");
        userIdentity.setProfile(userProfile);
        return userIdentity;
    }
}

