/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import javax.inject.Singleton;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.jpa.CommentDAOImpl;
import org.exoplatform.task.dao.jpa.LabelDAOImpl;
import org.exoplatform.task.dao.jpa.LabelTaskMappingDAOImpl;
import org.exoplatform.task.dao.jpa.ProjectDAOImpl;
import org.exoplatform.task.dao.jpa.StatusDAOImpl;
import org.exoplatform.task.dao.jpa.TaskDAOImpl;
import org.exoplatform.task.dao.jpa.TaskLogDAOImpl;
import org.exoplatform.task.dao.jpa.UserSettingDAO;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.service.impl.AbstractDAOHandler;

@Singleton
public class DAOHandlerJPAImpl
extends AbstractDAOHandler
implements DAOHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"DAOHandlerJPAImpl");

    public DAOHandlerJPAImpl() {
        LOG.info((Object)"DAOHandlerJPAImpl is creating...");
        this.pHandler = new ProjectDAOImpl();
        this.tHandler = new TaskDAOImpl();
        this.cHandler = new CommentDAOImpl();
        this.taskLogHandler = new TaskLogDAOImpl();
        this.sHandler = new StatusDAOImpl();
        this.uHandler = new UserSettingDAO();
        this.lHandler = new LabelDAOImpl();
        this.ltmHandler = new LabelTaskMappingDAOImpl();
        LOG.info((Object)"DAOHandlerJPAImpl is created");
    }

    static <E> E clone(E e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Task) {
            return (E)((Task)e).clone();
        }
        if (e instanceof Status) {
            return (E)((Status)e).clone();
        }
        if (e instanceof Project) {
            return (E)((Project)e).clone(false);
        }
        if (e instanceof Comment) {
            return (E)((Comment)e).clone();
        }
        if (e instanceof ChangeLog) {
            return (E)((ChangeLog)e).clone();
        }
        if (e instanceof UserSetting) {
            return (E)((UserSetting)e).clone();
        }
        return e;
    }
}

