/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import io.meeds.task.search.TaskSearchConnector;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.TestDtoUtils;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelTaskMappingHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskLogHandler;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.model.TaskSearchFilter;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.ProjectStorageImpl;
import org.exoplatform.task.storage.impl.TaskStorageImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TaskServiceTest {
    MockedStatic<ExoContainerContext> containerContext;
    TaskService taskService;
    TaskStorage taskStorage;
    StatusStorage statusStorage;
    ListenerService listenerService;
    TaskSearchConnector taskSearchConnector;
    @Mock
    TaskHandler taskHandler;
    @Mock
    ProjectHandler projectHandler;
    @Mock
    LabelTaskMappingHandler labelTaskMappingHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    CommentHandler commentHandler;
    @Mock
    TaskLogHandler taskLogHandler;
    @Mock
    StatusService statusService;
    @Mock
    ProjectStorage projectStorage;
    @Mock
    DAOHandler daoHandler;
    @Mock
    UserService userService;
    @Captor
    ArgumentCaptor<Task> taskCaptor;
    PortalContainer container;

    @Before
    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.listenerService = new ListenerService(new ExoContainerContext((ExoContainer)this.container));
        this.taskSearchConnector = (TaskSearchConnector)Mockito.mock(TaskSearchConnector.class);
        this.projectStorage = new ProjectStorageImpl(this.daoHandler);
        this.taskStorage = new TaskStorageImpl(this.daoHandler, this.userService, this.projectStorage, this.taskSearchConnector);
        this.taskService = new TaskServiceImpl(this.taskStorage, this.daoHandler, this.listenerService);
        this.containerContext = Mockito.mockStatic(ExoContainerContext.class);
        this.containerContext.when(() -> ExoContainerContext.getService((Class)((Class)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Class clazz = (Class)invocation.getArgument(0, Class.class);
            if (clazz.equals(DAOHandler.class)) {
                return this.daoHandler;
            }
            return this.container.getComponentInstanceOfType(clazz);
        });
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.daoHandler.getProjectHandler()).thenReturn((Object)this.projectHandler);
        Mockito.when((Object)this.daoHandler.getLabelTaskMappingHandler()).thenReturn((Object)this.labelTaskMappingHandler);
        Mockito.when((Object)this.daoHandler.getCommentHandler()).thenReturn((Object)this.commentHandler);
        Mockito.when((Object)this.daoHandler.getTaskLogHandler()).thenReturn((Object)this.taskLogHandler);
        Mockito.when((Object)((Task)this.taskHandler.create((Object)((Task)ArgumentMatchers.any(Task.class))))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)((Task)this.taskHandler.update((Object)((Task)ArgumentMatchers.any(Task.class))))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)((Task)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID)))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.statusService.getStatus(TestUtils.EXISTING_STATUS_ID)).thenReturn((Object)TestUtils.getDefaultStatusDto());
        Mockito.when((Object)this.daoHandler.getTaskHandler().getTaskWithCoworkers(1L)).thenReturn((Object)TestUtils.getDefaultTask());
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
    }

    @After
    public void tearDown() {
        this.taskService = null;
        this.containerContext.close();
        this.containerContext = null;
        ConversationState.setCurrent(null);
    }

    @Test
    public void testUpdateTaskTitle() throws Exception {
        String newTitle = "newTitle";
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setTitle(newTitle);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)newTitle, (Object)((Task)this.taskCaptor.getValue()).getTitle());
    }

    @Test
    public void testUpdateTaskDescription() throws EntityNotFoundException {
        String newDescription = "This is a new description";
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setDescription(newDescription);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)task.getDescription(), (Object)((Task)this.taskCaptor.getValue()).getDescription());
    }

    @Test
    public void testUpdateTaskCompleted() throws EntityNotFoundException {
        Boolean newCompleted = true;
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setCompleted(newCompleted.booleanValue());
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)newCompleted, (Object)((Task)this.taskCaptor.getValue()).isCompleted());
    }

    @Test
    public void testUpdateTaskAssignee() throws EntityNotFoundException {
        String newAssignee = "Tib";
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setAssignee(newAssignee);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)newAssignee, (Object)((Task)this.taskCaptor.getValue()).getAssignee());
    }

    @Test
    public void testUpdateTaskCoworker() throws EntityNotFoundException {
        HashSet<String> newCoworkers = new HashSet<String>();
        newCoworkers.add("Tib");
        newCoworkers.add("Trong");
        newCoworkers.add("Phuong");
        newCoworkers.add("TuyenTrong");
        newCoworkers.add("TuyenPhuong");
        newCoworkers.add("PhuongTuyen");
        newCoworkers.add("Tuyen");
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setCoworker(newCoworkers);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        HashSet<String> coworker = new HashSet<String>();
        for (String v : newCoworkers) {
            coworker.add(v);
        }
        Assert.assertEquals(coworker, (Object)((Task)this.taskCaptor.getValue()).getCoworker());
    }

    @Test
    public void testUpdateTaskWatcher() throws EntityNotFoundException {
        HashSet<String> newWatchers = new HashSet<String>();
        newWatchers.add("Tib");
        newWatchers.add("Trong");
        newWatchers.add("Phuong");
        newWatchers.add("Tuyen");
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setWatcher(newWatchers);
        Mockito.when((Object)this.daoHandler.getTaskHandler().getWatchersOfTask((Task)ArgumentMatchers.any())).thenReturn(newWatchers);
        this.taskService.getWatchersOfTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).getWatchersOfTask((Task)this.taskCaptor.capture());
        HashSet<String> newWatcher = new HashSet<String>();
        for (String v : newWatchers) {
            newWatcher.add(v);
        }
        Assert.assertEquals(newWatcher, (Object)((Task)this.taskCaptor.getValue()).getWatcher());
    }

    @Test
    public void testWatcherToTask() throws Exception {
        HashSet<String> newWatchers = new HashSet<String>();
        newWatchers.add("Tib");
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setWatcher(newWatchers);
        this.taskService.addWatcherToTask("Tib", task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).getWatchersOfTask((Task)this.taskCaptor.capture());
        HashSet<String> newWatcher = new HashSet<String>();
        for (String v : newWatchers) {
            newWatcher.add(v);
        }
        Assert.assertEquals(newWatcher, (Object)((Task)this.taskCaptor.getValue()).getWatcher());
    }

    @Test
    public void testUpdateTaskStatus() throws ParameterEntityException, EntityNotFoundException {
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setStatus(this.statusService.getStatus(TestUtils.EXISTING_STATUS_ID));
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
    }

    @Test
    public void testUpdateTaskDueDate() throws ParameterEntityException, EntityNotFoundException, ParseException {
        String dueDate = "1989-01-19";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(dueDate);
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setDueDate(date);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)date, (Object)((Task)this.taskCaptor.getValue()).getDueDate());
    }

    @Test
    public void testFindTasks() throws EntityNotFoundException {
        String newAssignee = "Tib";
        TaskDto task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        task.setAssignee(newAssignee);
        this.taskService.updateTask(task);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((Object)newAssignee, (Object)((Task)this.taskCaptor.getValue()).getAssignee());
        Assert.assertEquals((long)task.getId(), (long)((Task)this.taskCaptor.getValue()).getId());
    }

    @Test
    public void testDeleteTaskById() throws EntityNotFoundException {
        this.taskService.removeTask(TestUtils.EXISTING_TASK_ID);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).delete((Object)((Task)this.taskCaptor.capture()));
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)((Task)this.taskCaptor.getValue()).getId());
    }

    @Test
    public void testCloneTaskById() throws EntityNotFoundException {
        TaskDto defaultTask = TestDtoUtils.getDefaultTask();
        this.taskService.cloneTask(TestDtoUtils.EXISTING_TASK_ID);
        ArgumentCaptor taskCaptor = ArgumentCaptor.forClass(Task.class);
        ((TaskHandler)Mockito.verify((Object)this.taskHandler, (VerificationMode)Mockito.times((int)1))).create((Object)((Task)taskCaptor.capture()));
        Assert.assertEquals((Object)("Copy of " + defaultTask.getTitle()), (Object)((Task)taskCaptor.getValue()).getTitle());
        Assert.assertEquals((Object)defaultTask.getDescription(), (Object)((Task)taskCaptor.getValue()).getDescription());
        Assert.assertEquals((Object)defaultTask.getPriority(), (Object)((Task)taskCaptor.getValue()).getPriority());
        Assert.assertEquals((Object)defaultTask.getContext(), (Object)((Task)taskCaptor.getValue()).getContext());
        Assert.assertEquals((Object)defaultTask.getAssignee(), (Object)((Task)taskCaptor.getValue()).getAssignee());
        Assert.assertEquals((Object)defaultTask.getCoworker(), (Object)((Task)taskCaptor.getValue()).getCoworker());
        Assert.assertEquals((Object)defaultTask.getStatus(), (Object)((Task)taskCaptor.getValue()).getStatus());
        Assert.assertEquals((Object)defaultTask.getCreatedBy(), (Object)((Task)taskCaptor.getValue()).getCreatedBy());
        Assert.assertFalse((defaultTask.getCreatedTime() == ((Task)taskCaptor.getValue()).getCreatedTime() ? 1 : 0) != 0);
        Assert.assertEquals((Object)defaultTask.getEndDate(), (Object)((Task)taskCaptor.getValue()).getEndDate());
        Assert.assertEquals((Object)defaultTask.getStartDate(), (Object)((Task)taskCaptor.getValue()).getStartDate());
        Assert.assertEquals((Object)defaultTask.getDueDate(), (Object)((Task)taskCaptor.getValue()).getDueDate());
    }

    @Test
    public void testSearchTasks() throws Exception {
        TaskDto taskDto = this.taskStorage.createTask(TestDtoUtils.getDefaultTask());
        String currentUserId = "root";
        Mockito.when((Object)this.taskSearchConnector.search((TaskSearchFilter)ArgumentMatchers.any(TaskSearchFilter.class))).thenReturn(List.of(Long.valueOf(taskDto.getId())));
        List result = this.taskService.findTasksByMemberShips(currentUserId, new ArrayList(), "Default task", 10);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)((TaskDto)result.get(0)).getId(), (long)taskDto.getId());
        Assert.assertEquals((Object)((TaskDto)result.get(0)).getAssignee(), (Object)currentUserId);
    }
}

