/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.storage.search;

import io.meeds.task.search.TaskSearchConnector;
import java.util.List;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.task.model.TaskSearchFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskSearchConnectorTest {
    private static final String ES_INDEX = "task_alias";
    @Mock
    private ElasticSearchingClient client;
    @InjectMocks
    private TaskSearchConnector taskSearchConnector;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        ReflectionTestUtils.setField((Object)this.taskSearchConnector, (String)"index", (Object)ES_INDEX);
        ReflectionTestUtils.setField((Object)this.taskSearchConnector, (String)"searchType", (Object)"task");
    }

    @Test
    public void testSearchReturnsIds() {
        TaskSearchFilter filter = new TaskSearchFilter();
        filter.setLimit(5);
        filter.setOffset(0);
        filter.setTerm("test");
        filter.setPermissions(List.of("user1"));
        String jsonResponse = "{\n  \"hits\": {\n    \"hits\": [\n      { \"_id\": \"1\" },\n      { \"_id\": \"2\" }\n    ]\n  }\n}\n";
        Mockito.when((Object)this.client.sendRequest(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)jsonResponse);
        List result = this.taskSearchConnector.search(filter);
        Assert.assertEquals(List.of(Long.valueOf(1L), Long.valueOf(2L)), (Object)result);
    }

    @Test
    public void testCount() {
        TaskSearchFilter filter = new TaskSearchFilter();
        filter.setLimit(5);
        filter.setOffset(0);
        filter.setTerm("test");
        filter.setPermissions(List.of("user1"));
        String countResponse = "{\n  \"count\": 42\n}\n";
        Mockito.when((Object)this.client.countRequest(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)countResponse);
        long count = this.taskSearchConnector.count(filter);
        Assert.assertEquals((long)42L, (long)count);
    }
}

