/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import io.meeds.task.search.TaskSearchConnector;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.model.TaskSearchFilter;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.ProjectStorageImpl;
import org.exoplatform.task.storage.impl.TaskStorageImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TaskStorageTest
extends AbstractTest {
    private TaskHandler tDAO;
    private CommentHandler cDAO;
    private DAOHandler daoHandler;
    private final String username = "root";
    private LabelHandler labelHandler;
    private ListenerService listenerService;
    private ProjectStorage projectStorage;
    private UserService userService;
    private TaskStorage taskStorage;
    private TaskService taskService;
    private TaskSearchConnector taskSearchConnector;

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.taskSearchConnector = (TaskSearchConnector)Mockito.mock(TaskSearchConnector.class);
        this.tDAO = this.daoHandler.getTaskHandler();
        this.cDAO = this.daoHandler.getCommentHandler();
        this.projectStorage = new ProjectStorageImpl(this.daoHandler);
        this.labelHandler = this.daoHandler.getLabelHandler();
        this.taskStorage = new TaskStorageImpl(this.daoHandler, this.userService, this.projectStorage, this.taskSearchConnector);
        this.taskService = new TaskServiceImpl(this.taskStorage, this.daoHandler, this.listenerService);
    }

    @After
    public void tearDown() {
        this.deleteAll();
    }

    @Test
    public void findTaskWithMembership() throws Exception {
        Project project = new Project();
        project.setName("Project1");
        project.setParticipator(new HashSet<String>(Arrays.asList("jhon")));
        project = (Project)this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.newTaskInstance("Task 1", "", "root");
        task1.setStatus(status);
        this.tDAO.create((Object)task1);
        Project project2 = new Project();
        project2.setName("Project2");
        project2 = (Project)this.daoHandler.getProjectHandler().create((Object)project2);
        Status status1 = this.newStatusInstance("TO DO", 1);
        status1.setProject(project2);
        this.daoHandler.getStatusHandler().create((Object)status1);
        Task task2 = this.newTaskInstance("Task 2", "", "root");
        task2.setStatus(status1);
        this.tDAO.create((Object)task2);
        List<String> memberships = Arrays.asList("jhon");
        List tasks = this.taskStorage.findTasks("jhon", memberships, "", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Mockito.when((Object)this.taskSearchConnector.search((TaskSearchFilter)ArgumentMatchers.any(TaskSearchFilter.class))).thenReturn(List.of(task1.getId()));
        tasks = this.taskStorage.findTasks("jhon", memberships, "Task", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
    }

    private Status newStatusInstance(String name, int rank) {
        Status status = new Status();
        status.setName(name);
        status.setRank(Integer.valueOf(rank));
        return status;
    }

    private Task newTaskInstance(String taskTitle, String description, String assignee) {
        Task task = new Task();
        task.setTitle(taskTitle);
        task.setDescription(description);
        task.setAssignee(assignee);
        task.setCreatedBy("root");
        task.setCreatedTime(new Date());
        return task;
    }
}

