/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPeriodWithFullDate;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.utils.RewardUtils;

@Path(value="/wallet/api/reward/settings")
@RolesAllowed(value={"rewarding"})
@Tag(name="/wallet/api/reward/settings", description="Manage reward module settings")
public class RewardSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardSettingsREST.class);
    private RewardSettingsService rewardSettingsService;

    public RewardSettingsREST(RewardSettingsService rewardSettingsService) {
        this.rewardSettingsService = rewardSettingsService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Get reward settings", method="GET", description="returns reward settings object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSettings() {
        try {
            RewardSettings settings = this.rewardSettingsService.getSettings();
            return Response.ok((Object)(settings == null ? new RewardSettings() : settings)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Get reward settings", method="POST", description="returns reward settings object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveSettings(@Parameter(description="Reward settings object", required=true) RewardSettings rewardSettings) {
        if (rewardSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.rewardSettingsService.saveSettings(rewardSettings);
            LOG.info("{} saved reward settings '{}'", new Object[]{RewardUtils.getCurrentUserId(), rewardSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="getDates")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get dates corresponding to chosen period type and start date", method="GET", description="returns reward period dates object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRewardDates(@Parameter(description="A date with format yyyy-MM-dd", required=true) @QueryParam(value="date") String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return Response.status((int)400).entity((Object)"Bad request sent to server with empty 'date' parameter").build();
        }
        RewardSettings settings = this.rewardSettingsService.getSettings();
        ZoneId zoneId = settings.zoneId();
        RewardPeriodType rewardPeriodType = settings.getPeriodType();
        ZonedDateTime zonedDateTime = RewardUtils.parseRFC3339ToZonedDateTime(date, zoneId);
        RewardPeriod rewardPeriod = rewardPeriodType.getPeriodOfTime(zonedDateTime);
        RewardPeriodWithFullDate periodWithFullDate = new RewardPeriodWithFullDate(rewardPeriod);
        return Response.ok((Object)periodWithFullDate).build();
    }
}

