/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.statistic;

import io.meeds.analytics.model.StatisticData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.statistic.StatisticUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StatisticUtilsTest {
    @Test
    public void testParameterValidation() {
        Assert.assertThrows(IllegalArgumentException.class, () -> StatisticUtils.addStatisticEntry(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> StatisticUtils.addStatisticEntry(Collections.emptyMap()));
    }

    @Test
    public void testIsAnalyticsFeatureEnabled() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("remote_service", "REMOTE_SERVICE");
        parameters.put("operation", "OPERATION");
        parameters.put("status", "KO");
        parameters.put("status_code", "500");
        parameters.put("error_msg", "ERROR_MSG");
        parameters.put("duration_ms", 1220L);
        Wallet toWallet = this.addWallet(parameters, "to", 1L, "toWallet");
        Wallet fromWallet = this.addWallet(parameters, "fromWallet", 2L, "fromWallet");
        Wallet byWallet = this.addWallet(parameters, "byWallet", 1L, "byWallet");
        Wallet wallet = this.addWallet(parameters, "wallet", 1L, "wallet");
        AtomicReference statisticDataReference = new AtomicReference();
        StatisticUtils.addStatisticEntry(new HashMap<String, Object>(parameters), statisticData -> statisticDataReference.set(statisticData));
        StatisticData statisticData2 = (StatisticData)statisticDataReference.get();
        Assert.assertNotNull((Object)statisticData2);
        Assert.assertEquals((Object)"wallet", (Object)statisticData2.getModule());
        Assert.assertEquals(parameters.get("remote_service"), (Object)statisticData2.getSubModule());
        Assert.assertEquals(parameters.get("operation"), (Object)statisticData2.getOperation());
        Assert.assertEquals(parameters.get("error_msg"), (Object)statisticData2.getErrorMessage());
        Assert.assertEquals((long)Long.parseLong(parameters.get("duration_ms").toString()), (long)statisticData2.getDuration());
        Assert.assertEquals((Object)StatisticData.StatisticStatus.valueOf((String)parameters.get("status").toString().toUpperCase()), (Object)statisticData2.getStatus());
        Assert.assertEquals((long)Long.parseLong(parameters.get("status_code").toString()), (long)statisticData2.getErrorCode());
        Assert.assertEquals((long)0L, (long)statisticData2.getUserId());
        Assert.assertEquals((Object)String.valueOf(toWallet.getTechnicalId()), statisticData2.getParameters().get("toIdentityId"));
        Assert.assertEquals((Object)toWallet.getAddress(), statisticData2.getParameters().get("toWalletAddress"));
        Assert.assertEquals((Object)String.valueOf(fromWallet.getTechnicalId()), statisticData2.getParameters().get("fromIdentityId"));
        Assert.assertEquals((Object)fromWallet.getAddress(), statisticData2.getParameters().get("fromWalletAddress"));
        Assert.assertEquals((Object)String.valueOf(byWallet.getTechnicalId()), statisticData2.getParameters().get("byIdentityId"));
        Assert.assertEquals((Object)byWallet.getAddress(), statisticData2.getParameters().get("byWalletAddress"));
        Assert.assertEquals((Object)String.valueOf(wallet.getTechnicalId()), statisticData2.getParameters().get("identityId"));
        Assert.assertEquals((Object)wallet.getAddress(), statisticData2.getParameters().get("walletAddress"));
    }

    @Test
    public void testIsAnalyticsFeatureDisabled() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("local_service", "REMOTE_SERVICE");
        parameters.put("operation", "OPERATION");
        parameters.put("status", "KO");
        parameters.put("status_code", "500");
        parameters.put("error_msg", "ERROR_MSG");
        parameters.put("duration_ms", 1220L);
        this.addWallet(parameters, "to", 1L, "toWallet");
        this.addWallet(parameters, "fromWallet", 2L, "fromWallet");
        this.addWallet(parameters, "byWallet", 1L, "byWallet");
        this.addWallet(parameters, "wallet", 1L, "wallet");
        AtomicInteger analyticsConsumerInvocationCount = new AtomicInteger();
        StatisticUtils.addStatisticEntry(new HashMap<String, Object>(parameters), statisticData -> analyticsConsumerInvocationCount.incrementAndGet());
        Assert.assertEquals((long)1L, (long)analyticsConsumerInvocationCount.get());
    }

    private Wallet addWallet(Map<String, Object> parameters, String key, long technicalId, String address) {
        Wallet toWallet = new Wallet();
        toWallet.setTechnicalId(technicalId);
        toWallet.setAddress(address);
        parameters.put(key, toWallet);
        return toWallet;
    }
}

