/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.model;

import io.meeds.wallet.model.RewardBudgetType;
import io.meeds.wallet.model.RewardPeriodType;
import java.io.Serializable;
import java.time.ZoneId;
import lombok.Generated;

public class RewardSettings
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8650247964730374760L;
    private RewardPeriodType periodType = RewardPeriodType.DEFAULT;
    private String timeZone = ZoneId.systemDefault().getId();
    private RewardBudgetType budgetType = RewardBudgetType.DEFAULT;
    private double threshold = 0.0;
    private double amount;
    private boolean storedSetting;

    public ZoneId zoneId() {
        return ZoneId.of(this.timeZone);
    }

    public RewardSettings clone() {
        try {
            return (RewardSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new RewardSettings(this.periodType, this.timeZone, this.budgetType, this.threshold, this.amount, this.storedSetting);
        }
    }

    @Generated
    public RewardPeriodType getPeriodType() {
        return this.periodType;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public RewardBudgetType getBudgetType() {
        return this.budgetType;
    }

    @Generated
    public double getThreshold() {
        return this.threshold;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public boolean isStoredSetting() {
        return this.storedSetting;
    }

    @Generated
    public void setPeriodType(RewardPeriodType periodType) {
        this.periodType = periodType;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setBudgetType(RewardBudgetType budgetType) {
        this.budgetType = budgetType;
    }

    @Generated
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Generated
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Generated
    public void setStoredSetting(boolean storedSetting) {
        this.storedSetting = storedSetting;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardSettings)) {
            return false;
        }
        RewardSettings other = (RewardSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getThreshold(), other.getThreshold()) != 0) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (this.isStoredSetting() != other.isStoredSetting()) {
            return false;
        }
        RewardPeriodType this$periodType = this.getPeriodType();
        RewardPeriodType other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !((Object)((Object)this$periodType)).equals((Object)other$periodType)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        RewardBudgetType this$budgetType = this.getBudgetType();
        RewardBudgetType other$budgetType = other.getBudgetType();
        return !(this$budgetType == null ? other$budgetType != null : !((Object)((Object)this$budgetType)).equals((Object)other$budgetType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RewardSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = Double.doubleToLongBits(this.getThreshold());
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        result = result * 59 + (this.isStoredSetting() ? 79 : 97);
        RewardPeriodType $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : ((Object)((Object)$periodType)).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        RewardBudgetType $budgetType = this.getBudgetType();
        result = result * 59 + ($budgetType == null ? 43 : ((Object)((Object)$budgetType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RewardSettings(periodType=" + String.valueOf((Object)this.getPeriodType()) + ", timeZone=" + this.getTimeZone() + ", budgetType=" + String.valueOf((Object)this.getBudgetType()) + ", threshold=" + this.getThreshold() + ", amount=" + this.getAmount() + ", storedSetting=" + this.isStoredSetting() + ")";
    }

    @Generated
    public RewardSettings() {
    }

    @Generated
    public RewardSettings(RewardPeriodType periodType, String timeZone, RewardBudgetType budgetType, double threshold, double amount, boolean storedSetting) {
        this.periodType = periodType;
        this.timeZone = timeZone;
        this.budgetType = budgetType;
        this.threshold = threshold;
        this.amount = amount;
        this.storedSetting = storedSetting;
    }
}

