/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.service;

import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletAddressLabel;
import io.meeds.wallet.model.WalletProvider;
import io.meeds.wallet.model.WalletState;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface WalletAccountService {
    public Set<Wallet> listWallets();

    public Set<Wallet> listWalletsByIdentityIds(List<Long> var1);

    public long getWalletsCount();

    public Wallet getWalletByIdentityId(long var1);

    public Wallet getWalletByTypeAndId(String var1, String var2, String var3);

    public Wallet getWalletByTypeAndId(String var1, String var2);

    public Wallet getAdminWallet();

    public void savePrivateKeyByTypeAndId(String var1, String var2, String var3, String var4) throws IllegalAccessException;

    public String getPrivateKeyByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public String getPrivateKeyByTypeAndId(String var1, String var2);

    public void removePrivateKeyByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public Wallet getWalletByAddress(String var1, String var2);

    public Wallet getWalletByAddress(String var1);

    public void saveWalletBlockchainState(Wallet var1, String var2);

    public Wallet saveWalletBackupState(String var1, long var2, boolean var4) throws IllegalAccessException;

    public void saveWalletAddress(Wallet var1, String var2) throws IllegalAccessException;

    public Wallet saveWallet(Wallet var1, boolean var2);

    public Wallet createWalletInstance(WalletProvider var1, String var2, long var3);

    public void switchWalletProvider(long var1, WalletProvider var3, String var4, String var5, String var6);

    public void switchToInternalWallet(long var1);

    public void removeWalletByAddress(String var1, String var2) throws IllegalAccessException;

    public void removeWalletByTypeAndId(String var1, String var2, String var3) throws IllegalAccessException;

    public boolean enableWalletByAddress(String var1, boolean var2, String var3) throws IllegalAccessException;

    public boolean isWalletOwner(Wallet var1, String var2);

    public WalletAddressLabel saveOrDeleteAddressLabel(WalletAddressLabel var1, String var2);

    public Set<WalletAddressLabel> getAddressesLabelsVisibleBy(String var1);

    public void setInitializationStatus(String var1, WalletState var2, String var3) throws IllegalAccessException;

    public void setInitializationStatus(String var1, WalletState var2);

    public void createAdminAccount(String var1, String var2) throws IllegalAccessException;

    public String getAdminAccountPassword();

    public void refreshWalletsFromBlockchain(Map<String, Set<String>> var1);

    public void refreshWalletFromBlockchain(Wallet var1, ContractDetail var2, Map<String, Set<String>> var3);

    public void retrieveWalletBlockchainState(Wallet var1);

    public boolean isAdminAccountEnabled();
}

