/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.model;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.WalletReward;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RewardReport {
    private RewardPeriod period = null;
    private Set<WalletReward> rewards = new HashSet<WalletReward>();
    private int participationsCount;

    public long getPendingTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((CharSequence)rewardItem.getStatus(), (CharSequence)"pending")).count();
    }

    public long getSuccessTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((CharSequence)rewardItem.getStatus(), (CharSequence)"success")).count();
    }

    public long getFailedTransactionCount() {
        return this.rewards.stream().filter(rewardItem -> StringUtils.equals((CharSequence)rewardItem.getStatus(), (CharSequence)"error")).count();
    }

    public long getTransactionsCount() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getTransaction() != null).count();
    }

    public Set<WalletReward> getValidRewards() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getAmount() > 0.0 || rewardItem.getTokensSent() > 0.0).collect(Collectors.toSet());
    }

    public double getRemainingTokensToSend() {
        return this.rewards.stream().mapToDouble(rewardItem -> rewardItem.getTokensSent() == 0.0 ? rewardItem.getAmount() : 0.0).sum();
    }

    public long getValidRewardCount() {
        return this.rewards.stream().filter(rewardItem -> rewardItem.getAmount() > 0.0 || rewardItem.getTokensSent() > 0.0).count();
    }

    public double getTokensToSend() {
        return this.rewards.stream().mapToDouble(WalletReward::getAmount).sum();
    }

    public double getTokensSent() {
        return this.rewards.stream().mapToDouble(WalletReward::getTokensSent).sum();
    }

    public boolean hasSuccessTransactions() {
        return this.getSuccessTransactionCount() > 0L;
    }

    public boolean hasPendingTransactions() {
        return this.getPendingTransactionCount() > 0L;
    }

    public boolean hasErrorTransactions() {
        return this.getFailedTransactionCount() > 0L;
    }

    public boolean isCompletelyProcessed() {
        return this.getTransactionsCount() > 0L && this.getSuccessTransactionCount() >= this.getValidRewardCount();
    }

    @Generated
    public RewardReport() {
    }

    @Generated
    public RewardPeriod getPeriod() {
        return this.period;
    }

    @Generated
    public Set<WalletReward> getRewards() {
        return this.rewards;
    }

    @Generated
    public int getParticipationsCount() {
        return this.participationsCount;
    }

    @Generated
    public void setPeriod(RewardPeriod period) {
        this.period = period;
    }

    @Generated
    public void setRewards(Set<WalletReward> rewards) {
        this.rewards = rewards;
    }

    @Generated
    public void setParticipationsCount(int participationsCount) {
        this.participationsCount = participationsCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardReport)) {
            return false;
        }
        RewardReport other = (RewardReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getParticipationsCount() != other.getParticipationsCount()) {
            return false;
        }
        RewardPeriod this$period = this.getPeriod();
        RewardPeriod other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Set<WalletReward> this$rewards = this.getRewards();
        Set<WalletReward> other$rewards = other.getRewards();
        return !(this$rewards == null ? other$rewards != null : !((Object)this$rewards).equals(other$rewards));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RewardReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getParticipationsCount();
        RewardPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Set<WalletReward> $rewards = this.getRewards();
        result = result * 59 + ($rewards == null ? 43 : ((Object)$rewards).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RewardReport(period=" + String.valueOf(this.getPeriod()) + ", rewards=" + String.valueOf(this.getRewards()) + ", participationsCount=" + this.getParticipationsCount() + ")";
    }
}

