/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.model;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.utils.RewardUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public enum RewardPeriodType {
    WEEK,
    MONTH,
    QUARTER;

    public static final RewardPeriodType DEFAULT;

    public RewardPeriod getPeriodOfTime(LocalDate date, ZoneId zoneId) {
        ZonedDateTime zonedDateTime = date.atStartOfDay(zoneId);
        return this.getPeriodOfTime(zonedDateTime);
    }

    public RewardPeriod getPeriodOfTime(ZonedDateTime zonedDateTime) {
        ZoneId zoneId = zonedDateTime.getZone();
        RewardPeriod rewardPeriod = new RewardPeriod(this);
        rewardPeriod.setTimeZone(zoneId.getId());
        YearMonth yearMonth = YearMonth.from(zonedDateTime);
        switch (this.ordinal()) {
            case 0: {
                ZonedDateTime firstDayOfThisWeek = zonedDateTime.with(DayOfWeek.MONDAY);
                ZonedDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfThisWeek.toLocalDate(), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(firstDayOfNextWeek.toLocalDate(), zoneId));
                break;
            }
            case 1: {
                YearMonth nextMonth = yearMonth.plusMonths(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(yearMonth.atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(nextMonth.atDay(1), zoneId));
                break;
            }
            case 2: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSecondsAtDayStart(startQuarterMonth.atDay(1), zoneId));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSecondsAtDayStart(endQuarterMonth.atDay(1), zoneId));
            }
        }
        return rewardPeriod;
    }

    static {
        DEFAULT = WEEK;
    }
}

