/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.notification;

import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.notification.RewardSuccessTemplateProvider;
import io.meeds.wallet.reward.service.RewardSettingsService;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RewardSuccessTemplateProviderTest {
    @Test
    public void testGetTemplate() {
        RewardSettingsService rewardSettingsService = (RewardSettingsService)Mockito.mock(RewardSettingsService.class);
        Mockito.when((Object)rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardSuccessTemplateProvider provider = new RewardSuccessTemplateProvider(rewardSettingsService, this.getParams("MAIL_CHANNEL"));
        Map templateFilePathConfigs = provider.getTemplateFilePathConfigs();
        Assertions.assertNotNull((Object)templateFilePathConfigs);
        Assertions.assertEquals((int)1, (int)templateFilePathConfigs.size());
        String template = (String)templateFilePathConfigs.values().iterator().next();
        Assertions.assertEquals((Object)provider.getMailTemplatePath(), (Object)template);
        provider = new RewardSuccessTemplateProvider(rewardSettingsService, this.getParams("MAIL_CHANNEL"));
        templateFilePathConfigs = provider.getTemplateFilePathConfigs();
        Assertions.assertNotNull((Object)templateFilePathConfigs);
        Assertions.assertEquals((int)1, (int)templateFilePathConfigs.size());
        template = (String)templateFilePathConfigs.values().iterator().next();
        Assertions.assertEquals((Object)provider.getMailTemplatePath(), (Object)template);
        provider = new RewardSuccessTemplateProvider(rewardSettingsService, this.getParams("PUSH_CHANNEL"));
        templateFilePathConfigs = provider.getTemplateFilePathConfigs();
        Assertions.assertNotNull((Object)templateFilePathConfigs);
        Assertions.assertEquals((int)1, (int)templateFilePathConfigs.size());
        template = (String)templateFilePathConfigs.values().iterator().next();
        Assertions.assertEquals((Object)provider.getPushTemplatePath(), (Object)template);
    }

    private InitParams getParams(String channelId) {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("channel-id");
        valueParam.setValue(channelId);
        initParams.addParam((Object)valueParam);
        return initParams;
    }
}

