/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.rest;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardPeriodWithFullDate;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.utils.RewardUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"settings/reward"})
@Tag(name="reward/settings", description="Manage reward module settings")
public class RewardSettingsREST {
    @Autowired
    private RewardSettingsService rewardSettingsService;

    @GetMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Get reward settings", method="GET", description="returns reward settings object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public RewardSettings getSettings() {
        return this.rewardSettingsService.getSettings();
    }

    @PostMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Get reward settings", method="POST", description="returns reward settings object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void saveSettings(@RequestBody RewardSettings rewardSettings) {
        this.rewardSettingsService.saveSettings(rewardSettings);
    }

    @DeleteMapping
    @Secured(value={"rewarding"})
    @Operation(summary="Deletes reward settings.", description="Deletes reward settings.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public void deleteSettings() {
        this.rewardSettingsService.deleteSettings();
    }

    @GetMapping(path={"getDates"})
    @Secured(value={"users"})
    @Operation(summary="Get dates corresponding to chosen period type and start date", method="GET", description="returns reward period dates object")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRewardDates(@Parameter(description="A date with format yyyy-MM-dd", required=true) @RequestParam(value="date") String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Bad request sent to server with empty 'date' parameter");
        }
        RewardSettings settings = this.rewardSettingsService.getSettings();
        ZoneId zoneId = settings.zoneId();
        RewardPeriodType rewardPeriodType = settings.getPeriodType();
        ZonedDateTime zonedDateTime = RewardUtils.parseRFC3339ToZonedDateTime((String)date, (ZoneId)zoneId);
        RewardPeriod rewardPeriod = rewardPeriodType.getPeriodOfTime(zonedDateTime);
        RewardPeriodWithFullDate periodWithFullDate = new RewardPeriodWithFullDate(rewardPeriod);
        return Response.ok((Object)periodWithFullDate).build();
    }
}

