/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.service;

import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.service.RealizationService;
import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.DistributionForecast;
import io.meeds.wallet.model.RewardBudgetType;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.RewardStatus;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.model.WalletRewardPeriodSummary;
import io.meeds.wallet.model.WalletRewardStatus;
import io.meeds.wallet.model.WalletState;
import io.meeds.wallet.reward.service.RewardReportService;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.reward.service.WalletRewardReportService;
import io.meeds.wallet.reward.storage.WalletRewardReportStorage;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletTokenAdminService;
import io.meeds.wallet.utils.WalletUtils;
import java.io.InputStream;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={WalletRewardReportService.class})
public class WalletRewardReportServiceTest {
    private static final String ADMIN_USER = "root";
    private static final String SIMPLE_USER = "user";
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @MockBean
    private WalletAccountService walletAccountService;
    @MockBean
    private WalletTokenAdminService walletTokenAdminService;
    @MockBean
    private RewardSettingsService rewardSettingsService;
    @MockBean
    private WalletRewardReportStorage rewardReportStorage;
    @MockBean
    private RealizationService realizationService;
    @MockBean
    private ResourceBundleService resourceBundleService;
    @Autowired
    private RewardReportService rewardReportService;

    @BeforeEach
    void setup() {
        IdentityRegistry identityRegistry = (IdentityRegistry)PortalContainer.getInstance().getComponentInstanceOfType(IdentityRegistry.class);
        Identity identity = this.buildUserIdentityAsAdmin();
        identityRegistry.register(identity);
    }

    @Test
    void testComputeRewards() {
        LocalDate date = YearMonth.of(2019, 3).atEndOfMonth();
        RewardSettings rewardSettings = new RewardSettings();
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        RewardReport rewardReport = this.rewardReportService.computeRewards(date);
        Assertions.assertNotNull((Object)rewardReport);
        Assertions.assertNotNull((Object)rewardReport.getRewards());
        Assertions.assertEquals((int)0, (int)rewardReport.getRewards().size());
        Mockito.when((Object)this.realizationService.getParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)));
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.any(RealizationFilter.class))).thenReturn((Object)10);
        HashSet<Wallet> participantsWallet = new HashSet<Wallet>();
        participantsWallet.add(this.newWallet(1L));
        participantsWallet.add(this.newWallet(4L));
        participantsWallet.add(this.newWallet(5L));
        Mockito.when((Object)this.walletAccountService.listWalletsByIdentityIds(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)))).thenReturn(participantsWallet);
        rewardReport = this.rewardReportService.computeRewards(date);
        Assertions.assertNotNull((Object)rewardReport);
        Assertions.assertEquals((int)participantsWallet.size(), (int)rewardReport.getRewards().size());
        Mockito.when((Object)this.realizationService.getParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(new ArrayList());
        RewardPeriod rewardPeriod = new RewardPeriod();
        rewardPeriod.setId(1L);
        Mockito.when((Object)this.rewardReportService.getRewardPeriod(rewardSettings.getPeriodType(), date)).thenReturn((Object)rewardPeriod);
        this.rewardReportService.computeRewards(date);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).deleteRewardsByPeriodId(1L);
    }

    @Test
    void testGetRewardReportByPeriodId() {
        RewardSettings rewardSettings = new RewardSettings();
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        this.rewardReportService.getRewardReportByPeriodId(1L);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).getRewardReportByPeriodId(1L, rewardSettings.zoneId());
        this.rewardReportService.getRewardPeriod(RewardPeriodType.MONTH, LocalDate.now());
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).getRewardPeriod(RewardPeriodType.MONTH, LocalDate.now(), rewardSettings.zoneId());
    }

    @Test
    void testSaveRewardReport() {
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.rewardReportService.saveRewardReport(null));
        Assertions.assertEquals((Object)"Reward report to save is null", (Object)exception.getMessage());
        RewardReport rewardReport = new RewardReport();
        this.rewardReportService.saveRewardReport(rewardReport);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).saveRewardReport(rewardReport);
    }

    @Test
    void testGetRewardReport() {
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setPeriodType(null);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn(null);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.getRewardReport(LocalDate.now()));
        Assertions.assertEquals((Object)"Error computing rewards using empty settings", (Object)exception.getMessage());
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.getRewardReport(LocalDate.now()));
        Assertions.assertEquals((Object)"Error computing rewards using empty period type", (Object)exception.getMessage());
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        this.rewardReportService.getRewardReportByPeriodId(1L);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).getRewardReportByPeriodId(1L, rewardSettings.zoneId());
    }

    @Test
    void testGetReportStatus() {
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)new RewardSettings());
        RewardPeriod rewardPeriod = new RewardPeriod(RewardPeriodType.WEEK, ZoneId.systemDefault().getId(), 1725832800L, 1726437600L);
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn((Object)0L);
        this.rewardReportService.getReport(rewardPeriod);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)0))).createOrUpdateSummary((WalletRewardPeriodSummary)ArgumentMatchers.any(WalletRewardPeriodSummary.class));
        Mockito.when((Object)this.realizationService.countParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn((Object)4L);
        Mockito.when((Object)this.rewardReportStorage.getRewardPeriod((RewardPeriodType)ArgumentMatchers.any(RewardPeriodType.class), (LocalDate)ArgumentMatchers.any(LocalDate.class), (ZoneId)ArgumentMatchers.any(ZoneId.class))).thenReturn((Object)rewardPeriod);
        this.rewardReportService.getReport(rewardPeriod);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).createOrUpdateSummary((WalletRewardPeriodSummary)ArgumentMatchers.any(WalletRewardPeriodSummary.class));
        rewardPeriod.setId(4L);
        Mockito.when((Object)this.rewardReportStorage.getRewardPeriod((RewardPeriodType)ArgumentMatchers.any(RewardPeriodType.class), (LocalDate)ArgumentMatchers.any(LocalDate.class), (ZoneId)ArgumentMatchers.any(ZoneId.class))).thenReturn((Object)rewardPeriod);
        this.rewardReportService.getReport(rewardPeriod);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)2))).createOrUpdateSummary((WalletRewardPeriodSummary)ArgumentMatchers.any(WalletRewardPeriodSummary.class));
    }

    @Test
    void testFindRewardReportPeriods() {
        this.rewardReportService.findRewardReportPeriods(PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardReportPeriods(PAGEABLE);
        Mockito.when((Object)this.realizationService.isRealizationManager(SIMPLE_USER)).thenReturn((Object)false);
        Assert.assertThrows(IllegalAccessException.class, () -> this.rewardReportService.findRewardReportPeriods(SIMPLE_USER, PAGEABLE));
        Mockito.when((Object)this.realizationService.isRealizationManager(SIMPLE_USER)).thenReturn((Object)true);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardReportPeriods(PAGEABLE);
    }

    @Test
    void testFindRewardPeriodsBetween() {
        this.rewardReportService.findRewardPeriodsBetween(1725832800L, 1726437600L, PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardPeriodsBetween(1725832800L, 1726437600L, PAGEABLE);
        Mockito.when((Object)this.realizationService.isRealizationManager(SIMPLE_USER)).thenReturn((Object)false);
        Assert.assertThrows(IllegalAccessException.class, () -> this.rewardReportService.findRewardPeriodsBetween(SIMPLE_USER, 1725832800L, 1726437600L, PAGEABLE));
        Mockito.when((Object)this.realizationService.isRealizationManager(SIMPLE_USER)).thenReturn((Object)true);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardPeriodsBetween(1725832800L, 1726437600L, PAGEABLE);
    }

    @Test
    void testGetRewardPeriodsInProgress() {
        this.rewardReportService.getRewardPeriodsInProgress();
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardPeriodsByStatus(RewardStatus.PENDING);
    }

    @Test
    void testFindWalletRewardsByPeriodIdAndStatus() {
        RewardSettings rewardSettings = new RewardSettings();
        this.rewardReportService.findWalletRewardsByPeriodIdAndStatus(1L, null, WalletRewardStatus.ALL, rewardSettings.zoneId(), PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findWalletRewardsByPeriodId(1L, rewardSettings.zoneId(), WalletRewardStatus.ALL, PAGEABLE);
        this.rewardReportService.findWalletRewardsByPeriodIdAndStatus(1L, null, WalletRewardStatus.VALID, rewardSettings.zoneId(), PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findWalletRewardsByPeriodId(1L, rewardSettings.zoneId(), WalletRewardStatus.VALID, PAGEABLE);
        this.rewardReportService.findWalletRewardsByPeriodIdAndStatus(1L, null, WalletRewardStatus.ESTIMATED, rewardSettings.zoneId(), PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findWalletRewardsByPeriodId(1L, rewardSettings.zoneId(), WalletRewardStatus.ESTIMATED, PAGEABLE);
        this.rewardReportService.findWalletRewardsByPeriodIdAndStatus(1L, null, WalletRewardStatus.INELIGIBLE, rewardSettings.zoneId(), PAGEABLE);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findWalletRewardsByPeriodId(1L, rewardSettings.zoneId(), WalletRewardStatus.INELIGIBLE, PAGEABLE);
    }

    @Test
    void testGetRewardPeriodsNotSent() {
        this.rewardReportService.getRewardPeriodsNotSent();
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).findRewardPeriodsByStatus(RewardStatus.ESTIMATION);
    }

    @Test
    void testComputeRewardsByUser() {
        LocalDate date = YearMonth.of(2022, 12).atEndOfMonth();
        RewardSettings rewardSettings = new RewardSettings();
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        Mockito.when((Object)this.realizationService.getParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)));
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.any(RealizationFilter.class))).thenReturn((Object)10);
        HashSet<Wallet> participantsWallet = new HashSet<Wallet>();
        participantsWallet.add(this.newWallet(1L));
        participantsWallet.add(this.newWallet(4L));
        participantsWallet.add(this.newWallet(5L));
        Mockito.when((Object)this.walletAccountService.listWalletsByIdentityIds(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)))).thenReturn(participantsWallet);
        RewardReport rewardReport = this.rewardReportService.computeRewardsByUser(date, 1L);
        Assertions.assertNotNull((Object)rewardReport);
        Assertions.assertNotNull((Object)rewardReport.getRewards());
        Assertions.assertEquals((int)1, (int)rewardReport.getRewards().size());
    }

    @Test
    void testSendRewards() throws Exception {
        try (MockedStatic walletUtilsMockedStatic = Mockito.mockStatic(WalletUtils.class);){
            ContractDetail mockContractDetail = new ContractDetail();
            mockContractDetail.setDecimals(Integer.valueOf(12));
            walletUtilsMockedStatic.when(WalletUtils::getContractDetail).thenReturn((Object)mockContractDetail);
            walletUtilsMockedStatic.when(() -> WalletUtils.convertFromDecimals((BigInteger)((BigInteger)ArgumentMatchers.any(BigInteger.class)), (int)Mockito.anyInt())).thenReturn((Object)10.0);
            int contractDecimals = WalletUtils.getContractDetail().getDecimals();
            LocalDate date = YearMonth.of(2019, 4).atEndOfMonth();
            RewardSettings newSettings = new RewardSettings();
            newSettings.setPeriodType(RewardPeriodType.MONTH);
            double sumOfTokensToSend = 5490.0;
            newSettings.setBudgetType(RewardBudgetType.FIXED);
            newSettings.setAmount(sumOfTokensToSend);
            newSettings.setThreshold(0.0);
            Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)newSettings);
            HashMap<Long, Long> points = new HashMap<Long, Long>();
            points.put(1L, 50L);
            points.put(4L, 100L);
            points.put(5L, 40L);
            Mockito.when((Object)this.realizationService.getScoresByIdentityIdsAndBetweenDates(Mockito.anyList(), (Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(points);
            Mockito.when((Object)this.realizationService.getParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)));
            Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.any(RealizationFilter.class))).thenReturn((Object)10);
            HashSet<Wallet> participantsWallet = new HashSet<Wallet>();
            Wallet wallet = this.newWallet(1L);
            Wallet wallet4 = this.newWallet(4L);
            Wallet wallet5 = this.newWallet(5L);
            participantsWallet.add(wallet);
            participantsWallet.add(wallet4);
            participantsWallet.add(wallet5);
            Mockito.when((Object)this.walletAccountService.listWalletsByIdentityIds(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)))).thenReturn(participantsWallet);
            Mockito.when((Object)this.walletTokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf(10L).pow(contractDecimals));
            Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            Assertions.assertEquals((Object)"User root is not allowed to send rewards", (Object)exception.getMessage());
            walletUtilsMockedStatic.when(() -> WalletUtils.isUserRewardingAdmin((String)ADMIN_USER)).thenReturn((Object)true);
            exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            Assertions.assertEquals((Object)"No admin wallet is configured", (Object)exception.getMessage());
            Mockito.when((Object)this.walletTokenAdminService.getAdminWalletAddress()).thenReturn((Object)"adminAddress");
            exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            Assertions.assertEquals((Object)"Admin doesn't have enough funds to send rewards", (Object)exception.getMessage());
            walletUtilsMockedStatic.when(() -> WalletUtils.convertFromDecimals((BigInteger)((BigInteger)ArgumentMatchers.any(BigInteger.class)), (int)Mockito.anyInt())).thenReturn((Object)5491.0);
            Mockito.when((Object)this.walletTokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            this.rewardReportService.sendRewards(date, ADMIN_USER);
            ((WalletTokenAdminService)Mockito.verify((Object)this.walletTokenAdminService, (VerificationMode)Mockito.times((int)3))).reward((TransactionDetail)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
            Mockito.when((Object)this.walletTokenAdminService.getTokenBalanceOf("adminAddress")).thenReturn((Object)BigInteger.valueOf((long)sumOfTokensToSend + 1L).pow(contractDecimals));
            RewardReport rewardReport = new RewardReport();
            RewardPeriod rewardPeriod = new RewardPeriod();
            rewardReport.setPeriod(rewardPeriod);
            rewardReport.setParticipationsCount(10);
            HashSet<WalletReward> walletRewards = new HashSet<WalletReward>();
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setSucceeded(true);
            walletRewards.add(new WalletReward(1L, wallet, transactionDetail, 1L, 100.0, 10.0, rewardPeriod, 3));
            walletRewards.add(new WalletReward(2L, wallet4, transactionDetail, 4L, 200.0, 50.0, rewardPeriod, 2));
            walletRewards.add(new WalletReward(3L, wallet5, transactionDetail, 5L, 300.0, 40.0, rewardPeriod, 1));
            rewardReport.setRewards(walletRewards);
            Mockito.when((Object)this.rewardReportStorage.getRewardReport(newSettings.getPeriodType(), date, newSettings.zoneId())).thenReturn((Object)rewardReport);
            exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            Assertions.assertEquals((Object)"No rewards to send for selected period", (Object)exception.getMessage());
            transactionDetail.setSucceeded(false);
            rewardPeriod.setEndDateInSeconds(System.currentTimeMillis() / 1000L + 1L);
            exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            Assertions.assertEquals((Object)"Can't send rewards for current period", (Object)exception.getMessage());
            transactionDetail.setPending(true);
            rewardPeriod.setEndDateInSeconds(System.currentTimeMillis() / 1000L - 5L);
            exception = Assert.assertThrows(IllegalStateException.class, () -> this.rewardReportService.sendRewards(date, ADMIN_USER));
            String startDateFormatted = rewardReport.getPeriod().getStartDateFormatted(Locale.getDefault().getLanguage());
            String endDateFormatted = rewardReport.getPeriod().getEndDateFormatted(Locale.getDefault().getLanguage());
            Assertions.assertEquals((Object)("There are some pending transactions for rewards of period between " + startDateFormatted + " and " + endDateFormatted + ", thus no reward sending is allowed until the transactions finishes"), (Object)exception.getMessage());
        }
    }

    @Test
    void testComputeDistributionForecast() {
        RewardSettings rewardSettings = new RewardSettings();
        rewardSettings.setThreshold(49.0);
        Mockito.when((Object)this.realizationService.getParticipantsBetweenDates((Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)));
        Mockito.when((Object)this.realizationService.countRealizationsByFilter((RealizationFilter)ArgumentMatchers.any(RealizationFilter.class))).thenReturn((Object)10);
        HashSet<Wallet> participantsWallet = new HashSet<Wallet>();
        participantsWallet.add(this.newWallet(1L));
        participantsWallet.add(this.newWallet(4L));
        participantsWallet.add(this.newWallet(5L));
        Mockito.when((Object)this.walletAccountService.listWalletsByIdentityIds(List.of(Long.valueOf(1L), Long.valueOf(4L), Long.valueOf(5L)))).thenReturn(participantsWallet);
        HashMap<Long, Long> points = new HashMap<Long, Long>();
        points.put(1L, 50L);
        points.put(4L, 100L);
        points.put(5L, 40L);
        Mockito.when((Object)this.realizationService.getScoresByIdentityIdsAndBetweenDates(Mockito.anyList(), (Date)ArgumentMatchers.any(Date.class), (Date)ArgumentMatchers.any(Date.class))).thenReturn(points);
        DistributionForecast distributionForecast = this.rewardReportService.computeDistributionForecast(rewardSettings);
        Assertions.assertNotNull((Object)distributionForecast);
        Assertions.assertEquals((int)3, (int)distributionForecast.getParticipantsCount());
        Assertions.assertEquals((int)2, (int)distributionForecast.getEligibleContributorsCount());
        Assertions.assertEquals((double)190.0, (double)distributionForecast.getAcceptedContributions());
    }

    @Test
    void testListRewards() {
        RewardSettings rewardSettings = new RewardSettings();
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        this.rewardReportService.listRewards(ADMIN_USER, 10);
        this.rewardReportService.countRewards(ADMIN_USER);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).listRewards(1L, rewardSettings.zoneId(), 10);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).countRewards(1L);
    }

    @Test
    void testExportRewards() throws Exception {
        RewardSettings newSettings = new RewardSettings();
        WalletReward walletReward = new WalletReward();
        walletReward.setIdentityId(1L);
        walletReward.setPoints(200.0);
        walletReward.setAmount(50.0);
        Wallet wallet = new Wallet();
        wallet.setAddress("address1");
        walletReward.setWallet(new Wallet());
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSucceeded(true);
        transactionDetail.setHash("transactionHash");
        transactionDetail.setSentTimestamp(new Date().getTime());
        walletReward.setTransaction(transactionDetail);
        Mockito.when((Object)this.rewardReportStorage.findWalletRewardsByPeriodId(1L, newSettings.zoneId(), WalletRewardStatus.ALL, null)).thenReturn((Object)new PageImpl(List.of(walletReward)));
        ResourceBundle resourceBundle = (ResourceBundle)Mockito.mock(ResourceBundle.class);
        Mockito.when((Object)resourceBundle.getString(Mockito.anyString())).thenReturn((Object)"header");
        Mockito.when((Object)this.resourceBundleService.getResourceBundle(Mockito.anyString(), (Locale)ArgumentMatchers.any(Locale.class))).thenReturn((Object)resourceBundle);
        InputStream exportInputStream = this.rewardReportService.exportXlsx(1L, WalletRewardStatus.ALL, newSettings.zoneId(), "file-name", Locale.ENGLISH);
        Assertions.assertNotNull((Object)exportInputStream);
        Workbook workbook = WorkbookFactory.create((InputStream)exportInputStream);
        Assertions.assertNotNull((Object)workbook);
        Sheet sheet = workbook.getSheetAt(0);
        Assertions.assertNotNull((Object)sheet);
        Assertions.assertEquals((int)1, (int)sheet.getLastRowNum());
        Row header = sheet.getRow(0);
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((int)7, (int)header.getLastCellNum());
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)header.getCell((int)header.getFirstCellNum()).getStringCellValue()));
        Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)header.getCell(header.getLastCellNum() - 1).getStringCellValue()));
        Row row1 = sheet.getRow(1);
        Assertions.assertNotNull((Object)row1);
        Assertions.assertEquals((int)7, (int)row1.getLastCellNum());
        Assertions.assertEquals((double)200.0, (double)row1.getCell(2).getNumericCellValue());
        Assertions.assertEquals((Object)"MEED 50", (Object)row1.getCell(3).getStringCellValue());
        Assertions.assertEquals((Object)"success", (Object)row1.getCell(4).getStringCellValue());
    }

    @Test
    void testCountWalletRewardsPointsByPeriodIdAndStatus() {
        this.rewardReportService.countWalletRewardsPointsByPeriodIdAndStatus(1L, true);
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).countWalletRewardsPointsByPeriodIdAndStatus(1L, true);
    }

    @Test
    void testReplaceRewardTransactions() {
        this.rewardReportService.replaceRewardTransactions("oldHash", "newHash");
        ((WalletRewardReportStorage)Mockito.verify((Object)this.rewardReportStorage, (VerificationMode)Mockito.times((int)1))).replaceRewardTransactions("oldHash", "newHash");
    }

    protected Wallet newWallet(long identityId) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(identityId);
        wallet.setAddress("walletAddress" + identityId);
        wallet.setPassPhrase("passphrase");
        wallet.setEnabled(true);
        wallet.setIsInitialized(Boolean.valueOf(true));
        wallet.setEtherBalance(Double.valueOf(0.0));
        wallet.setTokenBalance(Double.valueOf(0.0));
        wallet.setInitializationState(WalletState.INITIALIZED.name());
        return wallet;
    }

    protected Identity buildUserIdentityAsAdmin() {
        String group = "/platform/rewarding";
        MembershipEntry entry = new MembershipEntry(group, "*");
        HashSet<MembershipEntry> entryTest = new HashSet<MembershipEntry>();
        entryTest.add(entry);
        return new Identity(ADMIN_USER, entryTest);
    }
}

