/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.listener;

import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.utils.Utils;
import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.reward.listener.RewardReportUpdateListener;
import io.meeds.wallet.reward.service.RewardSettingsService;
import io.meeds.wallet.reward.service.WalletRewardReportService;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={RewardReportUpdateListener.class})
class RewardReportUpdateListenerTest {
    @MockBean
    private WalletRewardReportService rewardReportService;
    @MockBean
    private RewardSettingsService rewardSettingsService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private RealizationService realizationService;
    @MockBean
    private Event<Object, Map<String, String>> event;
    @Autowired
    private RewardReportUpdateListener rewardReportUpdateListener;

    RewardReportUpdateListenerTest() {
    }

    @Test
    void onEvent() {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"reward.settings.updated");
        RewardPeriod rewardPeriod1 = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        RewardPeriod rewardPeriod2 = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)rewardPeriod1.getId()).thenReturn((Object)1L);
        Mockito.when((Object)rewardPeriod2.getId()).thenReturn((Object)2L);
        List<RewardPeriod> rewardPeriodsNotSent = List.of(rewardPeriod1, rewardPeriod2);
        Mockito.when((Object)this.rewardReportService.getRewardPeriodsNotSent()).thenReturn(rewardPeriodsNotSent);
        HashMap initialSettings = new HashMap();
        Mockito.when((Object)this.rewardReportService.getRewardSettingChanged()).thenReturn(initialSettings);
        this.rewardReportUpdateListener.onEvent(this.event);
        Map<Long, Boolean> expectedUpdatedSettings = rewardPeriodsNotSent.stream().collect(Collectors.toMap(RewardPeriod::getId, rewardPeriod -> true));
        ((WalletRewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).setRewardSettingChanged(expectedUpdatedSettings);
        List<RewardPeriod> rewardPeriods = Arrays.asList(rewardPeriod1, rewardPeriod2);
        Mockito.when((Object)this.rewardReportService.getRewardPeriodsNotSent()).thenReturn(rewardPeriods);
        HashMap rewardSettingChangedMap = new HashMap();
        Mockito.when((Object)this.rewardReportService.getRewardSettingChanged()).thenReturn(rewardSettingChangedMap);
        this.rewardReportUpdateListener.onEvent(this.event);
        ((WalletRewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)2))).getRewardPeriodsNotSent();
        ((WalletRewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)2))).getRewardSettingChanged();
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"OTHER_EVENT");
        RewardSettings rewardSettings = (RewardSettings)Mockito.mock(RewardSettings.class);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        RewardPeriod rewardPeriod3 = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)rewardPeriod3.getId()).thenReturn((Object)3L);
        try (MockedStatic mockedRewardPeriod = Mockito.mockStatic(RewardPeriod.class);){
            mockedRewardPeriod.when(() -> RewardPeriod.getCurrentPeriod((RewardSettings)rewardSettings)).thenReturn((Object)rewardPeriod3);
            Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
            Mockito.when((Object)rewardSettings.getPeriodType()).thenReturn((Object)RewardPeriodType.MONTH);
            Mockito.when((Object)this.rewardReportService.getRewardPeriod(RewardPeriodType.MONTH, LocalDate.now())).thenReturn((Object)rewardPeriod3);
            Mockito.when((Object)rewardPeriod3.getId()).thenReturn((Object)1L);
            initialSettings = new HashMap();
            Mockito.when((Object)this.rewardReportService.getRewardSettingChanged()).thenReturn(initialSettings);
            this.rewardReportUpdateListener.onEvent(this.event);
            expectedUpdatedSettings = new HashMap<Long, Boolean>();
            expectedUpdatedSettings.put(1L, true);
            ((WalletRewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).setRewardSettingChanged(expectedUpdatedSettings);
        }
    }

    @Test
    void onRealizationUpdateEvent() {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"reward.settings.updated");
        RewardPeriod rewardPeriod1 = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        RewardPeriod rewardPeriod2 = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)rewardPeriod1.getId()).thenReturn((Object)1L);
        Mockito.when((Object)rewardPeriod2.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"OTHER_EVENT");
        RealizationDTO realizationDTO = new RealizationDTO();
        realizationDTO.setId(Long.valueOf(1L));
        realizationDTO.setCreatedDate(Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis())));
        Mockito.when((Object)this.event.getSource()).thenReturn((Object)realizationDTO);
        RewardSettings rewardSettings = (RewardSettings)Mockito.mock(RewardSettings.class);
        Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
        RewardPeriod rewardPeriod = (RewardPeriod)Mockito.mock(RewardPeriod.class);
        Mockito.when((Object)rewardPeriod.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.rewardReportService.getRewardPeriod((RewardPeriodType)Mockito.any(RewardPeriodType.class), (LocalDate)Mockito.any(LocalDate.class))).thenReturn((Object)rewardPeriod);
        try (MockedStatic mockedRewardPeriod = Mockito.mockStatic(RewardPeriod.class);){
            mockedRewardPeriod.when(() -> RewardPeriod.getCurrentPeriod((RewardSettings)rewardSettings)).thenReturn((Object)rewardPeriod);
            Mockito.when((Object)this.rewardSettingsService.getSettings()).thenReturn((Object)rewardSettings);
            Mockito.when((Object)rewardSettings.getPeriodType()).thenReturn((Object)RewardPeriodType.MONTH);
            Mockito.when((Object)rewardSettings.zoneId()).thenReturn((Object)ZoneId.systemDefault());
            this.rewardReportUpdateListener.onEvent(this.event);
            HashMap<Long, Boolean> expectedUpdatedSettings = new HashMap<Long, Boolean>();
            expectedUpdatedSettings.put(2L, true);
            ((WalletRewardReportService)Mockito.verify((Object)this.rewardReportService, (VerificationMode)Mockito.times((int)1))).setRewardSettingChanged(expectedUpdatedSettings);
        }
    }
}

