/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.listener;

import io.meeds.wallet.listener.GamificationWalletInitializationListener;
import io.meeds.wallet.model.Wallet;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationWalletInitializationListenerTest {
    private static final String WALLET_ADDRESS = "0x123...7FED";
    private static final long IDENTITY_ID = 555L;
    @Mock
    private ListenerService listenerService;
    @Mock
    private Wallet wallet;
    @Mock
    private Event<Object, Object> event;

    @Test
    public void testInitializeWallet() throws Exception {
        GamificationWalletInitializationListener gamificationListener = new GamificationWalletInitializationListener(this.listenerService);
        Mockito.when((Object)this.wallet.getTechnicalId()).thenReturn((Object)555L);
        Mockito.when((Object)this.wallet.getAddress()).thenReturn((Object)WALLET_ADDRESS);
        Mockito.when((Object)this.event.getSource()).thenReturn((Object)this.wallet);
        gamificationListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("createWallet") && ((String)source.get("senderId")).equals(String.valueOf(555L)) && ((String)source.get("receiverId")).equals(String.valueOf(555L)) && ((String)source.get("objectType")).equals("wallet") && ((String)source.get("objectId")).equals(WALLET_ADDRESS))), ArgumentMatchers.eq(null));
    }
}

