/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.job;

import io.meeds.wallet.job.TransactionSenderJob;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.test.BaseWalletTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.quartz.JobExecutionException;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionSenderJobTest
extends BaseWalletTest {
    @Mock
    BlockchainTransactionService blockchainTransactionService;

    @Test
    public void testRunJob() throws JobExecutionException {
        TransactionSenderJob transactionSenderJob = new TransactionSenderJob();
        transactionSenderJob.blockchainTransactionService = this.blockchainTransactionService;
        transactionSenderJob.execute(null);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).sendPendingTransactionsToBlockchain();
    }

    @Test
    public void testRunJobWithExceptionDoesntExit() throws JobExecutionException {
        TransactionSenderJob transactionSenderJob = new TransactionSenderJob();
        transactionSenderJob.blockchainTransactionService = this.blockchainTransactionService;
        ((BlockchainTransactionService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("FAKE EXCEPTION")}).when((Object)this.blockchainTransactionService)).sendPendingTransactionsToBlockchain();
        transactionSenderJob.execute(null);
        ((BlockchainTransactionService)Mockito.verify((Object)this.blockchainTransactionService, (VerificationMode)Mockito.times((int)1))).sendPendingTransactionsToBlockchain();
    }
}

