/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.test;

import io.meeds.wallet.dao.AddressLabelDAO;
import io.meeds.wallet.dao.WalletAccountBackupDAO;
import io.meeds.wallet.dao.WalletAccountDAO;
import io.meeds.wallet.dao.WalletBlockchainStateDAO;
import io.meeds.wallet.dao.WalletPrivateKeyDAO;
import io.meeds.wallet.dao.WalletTransactionDAO;
import io.meeds.wallet.entity.AddressLabelEntity;
import io.meeds.wallet.entity.TransactionEntity;
import io.meeds.wallet.entity.WalletBackupEntity;
import io.meeds.wallet.entity.WalletBlockchainStateEntity;
import io.meeds.wallet.entity.WalletEntity;
import io.meeds.wallet.entity.WalletPrivateKeyEntity;
import io.meeds.wallet.model.ContractDetail;
import io.meeds.wallet.model.ContractTransactionEvent;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletAddressLabel;
import io.meeds.wallet.model.WalletState;
import io.meeds.wallet.model.WalletType;
import io.meeds.wallet.service.BlockchainTransactionService;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletService;
import io.meeds.wallet.storage.AddressLabelStorage;
import io.meeds.wallet.storage.TransactionStorage;
import io.meeds.wallet.storage.WalletStorage;
import io.meeds.wallet.storage.cached.CachedAccountStorage;
import io.meeds.wallet.storage.cached.CachedTransactionStorage;
import io.meeds.wallet.test.mock.IdentityManagerMock;
import io.meeds.wallet.test.mock.SpaceServiceMock;
import io.meeds.wallet.utils.WalletUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/wallet-services-test-configuration.xml")})
public abstract class BaseWalletTest
extends AbstractKernelTest {
    private static final Log LOG = ExoLogger.getLogger(BaseWalletTest.class);
    protected static final String WALLET_ADDRESS_1 = "0x1111111111111111111111111111111111111111";
    protected static final String WALLET_ADDRESS_2 = "0x2222222222222222222222222222222222222222";
    protected static final String WALLET_ADDRESS_3 = "0x3333333333333333333333333333333333333333";
    protected static final String TRANSACTION_LABEL = "TRANSACTION_LABEL";
    protected static final String TRANSACTION_MESSAGE = "TRANSACTION_MESSAGE";
    protected static final int GAS_USED = 160000;
    protected static final double GAS_PRICE = 6.0E-9;
    protected static final double GAS_PRICE_WEI = 6.0E9;
    protected static final String RAW_TRANSACTION = "RAW_TRANSACTION";
    protected static final double TOKEN_FEE = 0.96;
    protected static final long NONCE = 10L;
    protected static final double ETHER_VALUE = 0.001;
    protected static final String PHRASE = "passphrase";
    protected static final String INITIALIZATION_STATE = WalletState.INITIALIZED.name();
    protected static final String TYPE = WalletType.SPACE.name();
    protected static final boolean IS_ENABLED = true;
    protected static final String CURRENT_USER = "root1";
    protected static final long CURRENT_USER_IDENTITY_ID = 1L;
    protected static final String CURRENT_SPACE = "space1";
    protected static final long NETWORK_ID = 137L;
    protected static final int CONTRACT_AMOUNT = 500;
    protected static final String USER_TEST = "root9";
    protected static final long USER_TEST_IDENTITY_ID = 9L;
    @Rule
    public TestName testName = new TestName();
    protected Set<Serializable> entitiesToClean = null;
    protected Random random = new Random(1L);
    protected PortalContainer container;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.container == null) {
            BaseWalletTest.assertNotNull((String)"Container shouldn't be null", (Object)this.getContainer());
            BaseWalletTest.assertTrue((String)"Container should have been started", (boolean)this.getContainer().isStarted());
            IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
            BaseWalletTest.assertTrue((String)("Identity Manager should be mocked, found: " + identityManager.getClass().getName()), (boolean)(identityManager instanceof IdentityManagerMock));
            SpaceService spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
            BaseWalletTest.assertTrue((String)("SpaceService should be mocked, found: " + spaceService.getClass().getName()), (boolean)(spaceService instanceof SpaceServiceMock));
            this.container = this.getContainer();
            BlockchainTransactionService blockchainTransactionService = (BlockchainTransactionService)this.container.getComponentInstanceOfType(BlockchainTransactionService.class);
            if (blockchainTransactionService != null) {
                this.container.unregisterComponent(BlockchainTransactionService.class);
            }
            blockchainTransactionService = (BlockchainTransactionService)Mockito.mock(BlockchainTransactionService.class);
            Mockito.lenient().when((Object)blockchainTransactionService.getGasPrice()).thenReturn((Object)6.0E9);
            this.container.registerComponentInstance(BlockchainTransactionService.class, (Object)blockchainTransactionService);
            this.setContractDetails();
            this.setRoot1AsAdmin();
        }
        this.entitiesToClean = new HashSet<Serializable>();
        this.begin();
    }

    @After
    public void tearDown() throws Exception {
        TransactionStorage transactionStorage;
        super.tearDown();
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        WalletAccountBackupDAO walletAccountBackupDAO = this.getService(WalletAccountBackupDAO.class);
        AddressLabelDAO addressLabelDAO = this.getService(AddressLabelDAO.class);
        WalletPrivateKeyDAO walletPrivateKeyDAO = this.getService(WalletPrivateKeyDAO.class);
        WalletBlockchainStateDAO walletBlockchainStateDAO = this.getService(WalletBlockchainStateDAO.class);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        LOG.info("Cleaning {} objects after test finished", new Object[]{this.entitiesToClean.size()});
        this.restartTransaction();
        walletBlockchainStateDAO.deleteAll();
        this.restartTransaction();
        if (!this.entitiesToClean.isEmpty()) {
            Iterator<Serializable> iterator = this.entitiesToClean.iterator();
            while (iterator.hasNext()) {
                Serializable entity = iterator.next();
                if (entity == null) {
                    iterator.remove();
                    continue;
                }
                try {
                    WalletEntity wallet;
                    WalletBackupEntity walletBackupEntity;
                    if (entity instanceof WalletBackupEntity && (walletBackupEntity = (WalletBackupEntity)entity).getId() > 0L) {
                        if ((walletBackupEntity = (WalletBackupEntity)walletAccountBackupDAO.find((Serializable)walletBackupEntity.getId())) != null) {
                            walletAccountBackupDAO.delete((Object)walletBackupEntity);
                        }
                        iterator.remove();
                    }
                    if (entity instanceof WalletEntity) {
                        wallet = (WalletEntity)entity;
                        if (wallet.getId() <= 0L) continue;
                        WalletBackupEntity walletBackup = walletAccountBackupDAO.findByWalletId(wallet.getId().longValue());
                        if (walletBackup != null) {
                            walletAccountBackupDAO.delete((Object)walletBackup);
                        }
                        walletAccountDAO.delete((Object)((WalletEntity)walletAccountDAO.find((Serializable)wallet.getId())));
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof WalletPrivateKeyEntity) {
                        WalletPrivateKeyEntity privateKey = (WalletPrivateKeyEntity)entity;
                        if (privateKey.getId() <= 0L) continue;
                        walletPrivateKeyDAO.delete((Object)((WalletPrivateKeyEntity)walletPrivateKeyDAO.find((Serializable)privateKey.getId())));
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof TransactionEntity) {
                        TransactionEntity transactionEntity = (TransactionEntity)entity;
                        if (transactionEntity.getId() <= 0L) continue;
                        walletTransactionDAO.delete((Object)((TransactionEntity)walletTransactionDAO.find((Serializable)Long.valueOf(transactionEntity.getId()))));
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof AddressLabelEntity) {
                        AddressLabelEntity addressEntity = (AddressLabelEntity)entity;
                        if (addressEntity.getId() <= 0L) continue;
                        addressLabelDAO.delete((Object)((AddressLabelEntity)addressLabelDAO.find((Serializable)addressEntity.getId())));
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof WalletAddressLabel) {
                        AddressLabelEntity labelEntity = (AddressLabelEntity)addressLabelDAO.find((Serializable)Long.valueOf(((WalletAddressLabel)entity).getId()));
                        if (labelEntity.getId() <= 0L) continue;
                        addressLabelDAO.delete((Object)labelEntity);
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof TransactionDetail) {
                        long transactionId = ((TransactionDetail)entity).getId();
                        if (transactionId <= 0L) continue;
                        TransactionEntity transactionEntity = (TransactionEntity)walletTransactionDAO.find((Serializable)Long.valueOf(transactionId));
                        if (transactionEntity != null) {
                            walletTransactionDAO.delete((Object)transactionEntity);
                        }
                        iterator.remove();
                        continue;
                    }
                    if (entity instanceof Wallet) {
                        WalletEntity walletEntity;
                        wallet = (Wallet)entity;
                        long walletId = wallet.getTechnicalId();
                        if (walletId <= 0L) continue;
                        WalletBackupEntity walletBackup = walletAccountBackupDAO.findByWalletId(walletId);
                        if (walletBackup != null) {
                            walletAccountBackupDAO.delete((Object)walletBackup);
                        }
                        if ((walletEntity = (WalletEntity)walletAccountDAO.find((Serializable)Long.valueOf(walletId))) != null) {
                            WalletBlockchainStateEntity blockchainStateEntity = walletBlockchainStateDAO.findByWalletIdAndContract(walletId, WalletUtils.getContractAddress());
                            if (blockchainStateEntity != null) {
                                walletBlockchainStateDAO.delete((Object)blockchainStateEntity);
                            }
                            walletAccountDAO.delete((Object)walletEntity);
                        }
                        iterator.remove();
                        continue;
                    }
                    LOG.warn("Entity not managed {}", new Object[]{entity});
                }
                catch (Exception e) {
                    LOG.warn("Error cleaning entities after test '{}' execution", new Object[]{((Object)((Object)this)).getClass().getName(), e});
                }
            }
        }
        long walletCount = walletAccountDAO.count();
        long walletBackupCount = walletAccountBackupDAO.count();
        long walletPrivateKeyCount = walletPrivateKeyDAO.count();
        long walletAddressLabelsCount = addressLabelDAO.findAll().size();
        long walletTransactionsCount = walletTransactionDAO.count();
        LOG.info("objects count: remaining entities to clean: {}, wallets = {}, backupWallets = {}, private keys = {}, address labels = {}, transactions count = {}. Test method '{}#{}'", new Object[]{this.entitiesToClean, walletCount, walletBackupCount, walletPrivateKeyCount, walletAddressLabelsCount, walletTransactionsCount, ((Object)((Object)this)).getClass().getSimpleName(), this.testName.getMethodName()});
        BaseWalletTest.assertEquals((String)"The previous test didn't cleaned wallets entities correctly, should add entities to clean into 'entitiesToClean' list: ", (long)0L, (long)walletCount);
        BaseWalletTest.assertEquals((String)"The previous test didn't cleaned backupWallets entities correctly, should add entities to clean into 'entitiesToClean' list: ", (long)0L, (long)walletBackupCount);
        BaseWalletTest.assertEquals((String)"The previous test didn't cleaned wallet addresses labels correctly, should add entities to clean into 'entitiesToClean' list.", (long)0L, (long)walletAddressLabelsCount);
        BaseWalletTest.assertEquals((String)"The previous test didn't cleaned wallets private keys entities correctly, should add entities to clean into 'entitiesToClean' list.", (long)0L, (long)walletPrivateKeyCount);
        BaseWalletTest.assertEquals((String)"The previous test didn't cleaned wallets transactions entities correctly, should add entities to clean into 'entitiesToClean' list.", (long)0L, (long)walletTransactionsCount);
        AddressLabelStorage addressLabelStorage = this.getService(AddressLabelStorage.class);
        addressLabelStorage.clearCache();
        WalletStorage walletStorage = this.getService(WalletStorage.class);
        if (walletStorage instanceof CachedAccountStorage) {
            ((CachedAccountStorage)walletStorage).clearCache();
        }
        if ((transactionStorage = this.getService(TransactionStorage.class)) instanceof CachedTransactionStorage) {
            ((CachedTransactionStorage)transactionStorage).clearCache();
        }
        this.end();
    }

    protected List<TransactionEntity> generateTransactions(String walletAddress, String contractAddress, String contractMethodName) {
        return this.generateTransactions(walletAddress, contractAddress, contractMethodName, 0L);
    }

    protected List<TransactionEntity> generateTransactions(String walletAddress, String contractAddress, String contractMethodName, long offsetTime) {
        String secondAddress = "0xeaaaec7864af9e581a85ce3987d026be0f509ac9";
        String thirdAddress = "0xeaaaec7864af9e581a85ce3987d026be0f509ac9";
        String otherContractAddress = "0xeeefec7864af9e581a85ce3987d026be0f509aaa";
        String otherContractMethodName = "transferFrom";
        ArrayList<TransactionEntity> transactionEntities = new ArrayList<TransactionEntity>();
        for (int i = 0; i < 60; ++i) {
            String from;
            String to;
            String contractAddressToUse = null;
            String contractMethodNameToUse = null;
            if (StringUtils.isNotBlank((CharSequence)contractAddress)) {
                String string = contractAddressToUse = i % 2 == 0 ? contractAddress : otherContractAddress;
            }
            if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
                String string = i % 3 == 0 ? contractMethodName : (contractMethodNameToUse = i % 3 == 1 ? otherContractMethodName : null);
            }
            String string = i % 3 == 0 ? walletAddress : (to = i % 3 == 1 ? secondAddress : thirdAddress);
            String string2 = i % 3 == 0 ? thirdAddress : (from = i % 3 == 1 ? walletAddress : secondAddress);
            String by = i % 3 == 0 ? secondAddress : (i % 3 == 1 ? thirdAddress : walletAddress);
            TransactionEntity tx = this.createTransaction(null, contractAddressToUse, contractMethodNameToUse, 1.0, 3.0, from, to, by, 0L, "label", "message", true, i % 2 == 0, i, i % 2 != 0, System.currentTimeMillis() + offsetTime);
            transactionEntities.add(tx);
        }
        return transactionEntities;
    }

    protected TransactionEntity createTransaction(String hash, String contractAddress, String contractMethodName, double contractAmount, double value, String fromAddress, String toAddress, String byAddress, long issuerIdentityId, String label, String message, boolean isSuccess, boolean isPending, long nonce, boolean isAdminOperation, long createdDate) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            hash = this.generateTransactionHash();
        }
        if (StringUtils.isBlank((CharSequence)fromAddress)) {
            fromAddress = "0x" + this.random.nextInt(1000);
        }
        if (createdDate == 0L) {
            createdDate = ZonedDateTime.now().toInstant().toEpochMilli();
        }
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        TransactionEntity transactionEntity = new TransactionEntity();
        transactionEntity.setNetworkId(WalletUtils.getNetworkId());
        transactionEntity.setHash(StringUtils.lowerCase((String)hash));
        transactionEntity.setContractAddress(StringUtils.lowerCase((String)contractAddress));
        transactionEntity.setContractMethodName(contractMethodName);
        transactionEntity.setContractAmount(contractAmount);
        transactionEntity.setValue(value);
        transactionEntity.setFromAddress(StringUtils.lowerCase((String)fromAddress));
        transactionEntity.setToAddress(StringUtils.lowerCase((String)toAddress));
        transactionEntity.setByAddress(StringUtils.lowerCase((String)byAddress));
        transactionEntity.setIssuerIdentityId(issuerIdentityId);
        transactionEntity.setLabel(label);
        transactionEntity.setMessage(message);
        transactionEntity.setSuccess(isSuccess);
        transactionEntity.setPending(isPending);
        transactionEntity.setAdminOperation(isAdminOperation);
        transactionEntity.setCreatedDate(createdDate);
        transactionEntity.setNonce(nonce);
        transactionEntity = (TransactionEntity)walletTransactionDAO.create((Object)transactionEntity);
        this.entitiesToClean.add((Serializable)transactionEntity);
        return transactionEntity;
    }

    protected TransactionDetail createTransactionDetail(String hash, String contractMethodName, double contractAmount, double value, String fromAddress, String toAddress, String byAddress, long issuerIdentityId, String label, String message, boolean isSuccess, boolean isPending, boolean isAdminOperation, String rawTransaction, long createdDate) {
        if (StringUtils.isBlank((CharSequence)hash)) {
            hash = this.generateTransactionHash();
        }
        if (StringUtils.isBlank((CharSequence)fromAddress)) {
            fromAddress = "0x" + this.random.nextInt(1000);
        }
        if (createdDate == 0L) {
            createdDate = ZonedDateTime.now().toInstant().toEpochMilli();
        }
        TransactionStorage transactionStorage = this.getService(TransactionStorage.class);
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setNetworkId(137L);
        transactionDetail.setHash(StringUtils.lowerCase((String)hash));
        transactionDetail.setContractAddress(WalletUtils.getContractAddress());
        transactionDetail.setContractMethodName(contractMethodName);
        transactionDetail.setContractAmount(contractAmount);
        transactionDetail.setValue(value);
        transactionDetail.setFrom(StringUtils.lowerCase((String)fromAddress));
        transactionDetail.setTo(StringUtils.lowerCase((String)toAddress));
        transactionDetail.setBy(StringUtils.lowerCase((String)byAddress));
        transactionDetail.setIssuerId(issuerIdentityId);
        transactionDetail.setLabel(label);
        transactionDetail.setMessage(message);
        transactionDetail.setSucceeded(isSuccess);
        transactionDetail.setPending(isPending);
        transactionDetail.setAdminOperation(isAdminOperation);
        transactionDetail.setTimestamp(createdDate);
        transactionDetail.setGasPrice(6.0E-9);
        transactionDetail.setGasUsed(160000);
        transactionDetail.setTokenFee(0.96);
        transactionDetail.setNonce(10L);
        transactionDetail.setNoContractFunds(true);
        transactionDetail.setRawTransaction(rawTransaction);
        transactionStorage.saveTransactionDetail(transactionDetail);
        this.entitiesToClean.add((Serializable)transactionDetail);
        return transactionDetail;
    }

    protected String generateTransactionHash() {
        StringBuilder hashStringBuffer = new StringBuilder("0x");
        for (int i = 0; i < 64; ++i) {
            hashStringBuffer.append(Integer.toHexString(this.random.nextInt(16)));
        }
        return hashStringBuffer.toString();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)this.container.getComponentInstanceOfType(componentType);
    }

    protected Identity buildUserIdentityAsAdmin(String currentUser) {
        String group = "/platform/rewarding";
        MembershipEntry entry = new MembershipEntry(group, "*");
        HashSet<MembershipEntry> entryTest = new HashSet<MembershipEntry>();
        entryTest.add(entry);
        return new Identity(currentUser, entryTest);
    }

    protected Wallet newWallet() {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(1L);
        wallet.setAddress(WALLET_ADDRESS_1);
        wallet.setPassPhrase(PHRASE);
        wallet.setEnabled(true);
        wallet.setInitializationState(INITIALIZATION_STATE);
        return wallet;
    }

    protected Wallet newWalletSpace() {
        Wallet walletSpace = new Wallet();
        walletSpace.setTechnicalId(1L);
        walletSpace.setAddress(WALLET_ADDRESS_1);
        walletSpace.setPassPhrase(PHRASE);
        walletSpace.setEnabled(true);
        walletSpace.setId(CURRENT_SPACE);
        walletSpace.setInitializationState(INITIALIZATION_STATE);
        walletSpace.setSpaceAdministrator(true);
        walletSpace.setType(TYPE);
        return walletSpace;
    }

    protected void addCurrentUserWallet() {
        WalletAccountService walletAccountService = this.getService(WalletAccountService.class);
        Wallet wallet = this.newWallet();
        try {
            walletAccountService.saveWalletAddress(wallet, CURRENT_USER);
        }
        catch (IllegalAccessException e) {
            BaseWalletTest.fail((String)"User should be able to save his wallet");
        }
        this.entitiesToClean.add((Serializable)wallet);
    }

    private void setContractDetails() {
        WalletService walletService = (WalletService)this.container.getComponentInstanceOfType(WalletService.class);
        ContractDetail contractDetail = new ContractDetail();
        contractDetail.setName("name");
        contractDetail.setSymbol("symbol");
        contractDetail.setDecimals(Integer.valueOf(12));
        contractDetail.setAddress(WalletUtils.getContractAddress());
        contractDetail.setContractType("3");
        contractDetail.setNetworkId(Long.valueOf(1L));
        walletService.setConfiguredContractDetail(contractDetail);
    }

    protected org.web3j.protocol.core.methods.response.Log newLog() {
        ContractTransactionEvent contractTransactionEvent = this.newContractTransactionEvent();
        org.web3j.protocol.core.methods.response.Log log = (org.web3j.protocol.core.methods.response.Log)Mockito.mock(org.web3j.protocol.core.methods.response.Log.class);
        Mockito.when((Object)log.getTopics()).thenReturn((Object)contractTransactionEvent.getTopics());
        Mockito.when((Object)log.getData()).thenReturn((Object)contractTransactionEvent.getData());
        Mockito.when((Object)log.getBlockNumber()).thenReturn((Object)BigInteger.valueOf(contractTransactionEvent.getBlockNumber()));
        Mockito.when((Object)log.getTransactionHash()).thenReturn((Object)contractTransactionEvent.getTransactionHash());
        Mockito.when((Object)log.getAddress()).thenReturn((Object)contractTransactionEvent.getContractAddress());
        return log;
    }

    protected void setRoot1AsAdmin() {
        IdentityRegistry identityRegistry = this.getService(IdentityRegistry.class);
        Identity identity = this.buildUserIdentityAsAdmin(CURRENT_USER);
        identityRegistry.register(identity);
    }

    protected ContractTransactionEvent newContractTransactionEvent() {
        String hash = "transactionHash";
        String contractAddress = "0x334d85047da64738c065d36e10b2adeb965000d0";
        String data = "0x0000000000000000000000000000000000000000000000001bc16d674ec80000";
        List<String> topics = Arrays.asList("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef", "0x0000000000000000000000002b7e115f52171d164529fdb1ac72571e608a474e", "0x0000000000000000000000001d94f732223996e9f773261e82340889934a6c03");
        long blockNumber = 28047704L;
        return new ContractTransactionEvent(hash, contractAddress, data, topics, blockNumber);
    }
}

