/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.blockchain.service;

import io.meeds.wallet.blockchain.service.EthereumClientConnector;
import io.meeds.wallet.model.ContractTransactionEvent;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.test.BaseWalletTest;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketService;

@RunWith(value=MockitoJUnitRunner.class)
public class EthereumClientConnectorTest
extends BaseWalletTest {
    @Mock
    private Web3j web3j;
    @Mock
    private CacheService cacheService;
    @Mock
    private WebSocketClient webSocketClient;
    @Mock
    private WebSocketService web3jService;
    @Mock
    private ListenerService listenerService;
    private boolean webSocketConnected;
    private boolean subscriptionDisposed;
    private EthereumClientConnector service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Mockito.when((Object)this.cacheService.getCacheInstance((String)ArgumentMatchers.any())).thenReturn((Object)new ConcurrentFIFOExoCache());
        this.instantiateService();
        Mockito.when((Object)this.webSocketClient.reconnectBlocking()).thenAnswer(invocation -> {
            this.webSocketConnected = true;
            return true;
        });
        Mockito.when((Object)this.webSocketClient.isOpen()).thenAnswer(invocation -> this.webSocketConnected);
        this.setAsDisconnected();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service.stop();
        this.setAsDisconnected();
    }

    @Test
    public void testServiceStartWithDefaultSettings() {
        this.service.start();
        EthereumClientConnectorTest.assertFalse((boolean)this.service.isListeningToBlockchain());
        EthereumClientConnectorTest.assertFalse((boolean)this.service.isPermanentlyScanBlockchain());
        EthereumClientConnectorTest.assertEquals((long)15000L, (long)this.service.getPollingInterval());
    }

    @Test
    public void testServiceStartWithPermanentListening() {
        System.setProperty("exo.wallet.blockchain.permanentlyScan", "true");
        System.setProperty("exo.wallet.blockchain.polling.intervalInSeconds", "32000");
        this.instantiateService();
        this.service.start();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isPermanentlyScanBlockchain());
        EthereumClientConnectorTest.assertEquals((long)32000000L, (long)this.service.getPollingInterval());
    }

    @Test
    public void testServiceStop() {
        this.service.start();
        EthereumClientConnectorTest.assertFalse((boolean)this.service.isConnected());
        this.setAsConnected();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isConnected());
        this.service.stop();
        EthereumClientConnectorTest.assertFalse((boolean)this.service.isConnected());
    }

    @Test
    public void testConnect() throws Exception {
        this.service.start();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.connect());
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isConnected());
        EthereumClientConnectorTest.assertTrue((boolean)this.service.connect());
        this.service.stop();
        EthereumClientConnectorTest.assertFalse((boolean)this.service.isConnected());
        EthereumClientConnectorTest.assertFalse((boolean)this.service.connect());
    }

    @Test
    public void testRenewTransactionListeningSubscription() throws Exception {
        this.service.start();
        this.service.connect();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isConnected());
        long lastWatchedBlockNumber = 12L;
        this.service.setLastWatchedBlockNumber(lastWatchedBlockNumber);
        Flowable flowable = (Flowable)Mockito.mock(Flowable.class);
        Mockito.when((Object)this.web3j.ethLogFlowable((EthFilter)ArgumentMatchers.any())).thenReturn((Object)flowable);
        Disposable ethFilterSubscribtion = (Disposable)Mockito.mock(Disposable.class);
        AtomicReference onNext = new AtomicReference();
        AtomicReference onError = new AtomicReference();
        Mockito.when((Object)flowable.subscribe((Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenAnswer(invocation -> {
            onNext.set((Consumer)invocation.getArgument(0, Consumer.class));
            onError.set((Consumer)invocation.getArgument(1, Consumer.class));
            return ethFilterSubscribtion;
        });
        this.subscriptionDisposed = false;
        Mockito.when((Object)ethFilterSubscribtion.isDisposed()).thenAnswer(invocation -> this.subscriptionDisposed);
        ((Disposable)Mockito.doAnswer(invocation -> {
            this.subscriptionDisposed = true;
            return true;
        }).when((Object)ethFilterSubscribtion)).dispose();
        Future future = this.service.renewTransactionListeningSubscription(0L);
        Disposable disposable = (Disposable)future.get();
        EthereumClientConnectorTest.assertEquals((Object)ethFilterSubscribtion, (Object)disposable);
        Log log = this.newLog();
        ((Consumer)onNext.get()).accept((Object)log);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedForContract", null, (Object)new ContractTransactionEvent(log.getTransactionHash(), log.getAddress(), log.getData(), log.getTopics(), log.getBlockNumber().longValue()));
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isListeningToBlockchain());
        EthereumClientConnectorTest.assertFalse((boolean)ethFilterSubscribtion.isDisposed());
        this.service.cancelTransactionListeningToBlockchain();
        EthereumClientConnectorTest.assertTrue((boolean)ethFilterSubscribtion.isDisposed());
    }

    @Test
    public void testGetNotFoundTransaction() {
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransaction("test"));
    }

    @Test
    public void testGetTransactionWhenThrowException() throws Exception {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.send()).thenThrow(IOException.class);
        Mockito.when((Object)this.web3j.ethGetTransactionByHash(transactionHash)).thenReturn((Object)request);
        this.service.start();
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransaction(transactionHash));
    }

    @Test
    public void testGetTransactionTwiceWhenNullUsingCache() {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGetTransactionByHash(transactionHash)).thenReturn((Object)request);
        this.service.start();
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransaction(transactionHash));
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransaction(transactionHash));
        ((Web3j)Mockito.verify((Object)this.web3j, (VerificationMode)Mockito.times((int)2))).ethGetTransactionByHash(transactionHash);
    }

    @Test
    public void testGetTransactionTwiceUsingCacheWithAResult() throws Exception {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        EthTransaction ethTransaction = (EthTransaction)Mockito.mock(EthTransaction.class);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethTransaction);
        Mockito.when((Object)((Transaction)ethTransaction.getResult())).thenReturn((Object)transaction);
        Mockito.when((Object)this.web3j.ethGetTransactionByHash(transactionHash)).thenReturn((Object)request);
        this.service.start();
        EthereumClientConnectorTest.assertEquals((Object)transaction, (Object)this.service.getTransaction(transactionHash));
        EthereumClientConnectorTest.assertEquals((Object)transaction, (Object)this.service.getTransaction(transactionHash));
        ((Web3j)Mockito.verify((Object)this.web3j, (VerificationMode)Mockito.times((int)1))).ethGetTransactionByHash(transactionHash);
    }

    @Test
    public void testGetNotFoundTransactionReceipt() {
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransactionReceipt("test"));
    }

    @Test
    public void testGetTransactionReceiptWhenThrowException() throws Exception {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.send()).thenThrow(IOException.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)request);
        this.service.start();
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransactionReceipt(transactionHash));
    }

    @Test
    public void testGetTransactionReceiptTwiceWhenNullUsingCache() {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)request);
        this.service.start();
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransactionReceipt(transactionHash));
        EthereumClientConnectorTest.assertNull((Object)this.service.getTransactionReceipt(transactionHash));
        ((Web3j)Mockito.verify((Object)this.web3j, (VerificationMode)Mockito.times((int)2))).ethGetTransactionReceipt(transactionHash);
    }

    @Test
    public void testGetTransactionReceiptTwiceUsingCacheWithAResult() throws Exception {
        String transactionHash = "test";
        Request request = (Request)Mockito.mock(Request.class);
        EthGetTransactionReceipt ethTransactionReceipt = (EthGetTransactionReceipt)Mockito.mock(EthGetTransactionReceipt.class);
        TransactionReceipt transactionReceipt = (TransactionReceipt)Mockito.mock(TransactionReceipt.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethTransactionReceipt);
        Mockito.when((Object)((TransactionReceipt)ethTransactionReceipt.getResult())).thenReturn((Object)transactionReceipt);
        this.service.start();
        Mockito.when((Object)this.web3j.ethGetTransactionReceipt(transactionHash)).thenReturn((Object)request);
        EthereumClientConnectorTest.assertEquals((Object)transactionReceipt, (Object)this.service.getTransactionReceipt(transactionHash));
        EthereumClientConnectorTest.assertEquals((Object)transactionReceipt, (Object)this.service.getTransactionReceipt(transactionHash));
        ((Web3j)Mockito.verify((Object)this.web3j, (VerificationMode)Mockito.times((int)1))).ethGetTransactionReceipt(transactionHash);
    }

    @Test
    public void testSendTransactionToBlockchainAsync() throws Exception {
        String rawTransaction = "test";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setRawTransaction(rawTransaction);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethSendRawTransaction(rawTransaction)).thenReturn((Object)request);
        this.service.sendTransactionToBlockchain(transactionDetail);
        ((Request)Mockito.verify((Object)request, (VerificationMode)Mockito.times((int)1))).sendAsync();
    }

    @Test
    public void testGetLastestBlockNumberThrowExceptionWhenIOException() throws Exception {
        String rawTransaction = "test";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setRawTransaction(rawTransaction);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethBlockNumber()).thenReturn((Object)request);
        Mockito.when((Object)request.send()).thenThrow(IOException.class);
        this.service.start();
        Assert.assertThrows(IllegalStateException.class, () -> this.service.getLastestBlockNumber());
    }

    @Test
    public void testGetLastestBlockNumberSync() throws Exception {
        String rawTransaction = "test";
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setRawTransaction(rawTransaction);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethBlockNumber()).thenReturn((Object)request);
        EthBlockNumber ethBlockNumber = (EthBlockNumber)Mockito.mock(EthBlockNumber.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethBlockNumber);
        Mockito.when((Object)ethBlockNumber.getBlockNumber()).thenReturn((Object)BigInteger.TWO);
        this.service.start();
        EthereumClientConnectorTest.assertEquals((long)2L, (long)this.service.getLastestBlockNumber());
    }

    @Test
    public void testGetGasPrice() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGasPrice()).thenReturn((Object)request);
        EthGasPrice ethGasPrice = (EthGasPrice)Mockito.mock(EthGasPrice.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethGasPrice);
        Mockito.when((Object)ethGasPrice.getGasPrice()).thenReturn((Object)BigInteger.TWO);
        EthereumClientConnectorTest.assertEquals((Object)BigInteger.TWO, (Object)this.service.getGasPrice());
    }

    @Test
    public void testGetLatestNonceByDefault() throws Exception {
        String walletAddress = "address";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGetTransactionCount(walletAddress, (DefaultBlockParameter)DefaultBlockParameterName.LATEST)).thenReturn((Object)request);
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
        Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)BigInteger.TEN);
        EthereumClientConnectorTest.assertEquals((Object)BigInteger.TEN, (Object)this.service.getNonce(walletAddress));
    }

    @Test
    public void testGetNonceByBlock() throws Exception {
        String walletAddress = "address";
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)this.web3j.ethGetTransactionCount(walletAddress, (DefaultBlockParameter)DefaultBlockParameterName.PENDING)).thenReturn((Object)request);
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)Mockito.mock(EthGetTransactionCount.class);
        Mockito.when((Object)request.send()).thenReturn((Object)ethGetTransactionCount);
        Mockito.when((Object)ethGetTransactionCount.getTransactionCount()).thenReturn((Object)BigInteger.TEN);
        EthereumClientConnectorTest.assertEquals((Object)BigInteger.TEN, (Object)this.service.getNonce(walletAddress, DefaultBlockParameterName.PENDING));
    }

    @Test
    public void testSetPollingIntervalWhenLowerThanMinimum() {
        Assert.assertThrows(IllegalStateException.class, () -> this.service.setPollingInterval(1999L));
    }

    @Test
    public void testSetPollingIntervalWhenGreaterThanMinimum() {
        int pollingInterval = 2001;
        this.service.setPollingInterval((long)pollingInterval);
        EthereumClientConnectorTest.assertEquals((long)pollingInterval, (long)this.service.getPollingInterval());
    }

    @Test
    public void testGetPollingIntervalDefaultValue() {
        EthereumClientConnectorTest.assertEquals((long)15000L, (long)this.service.getPollingInterval());
    }

    @Test
    public void testSetLastWatchedBlockNumberGreaterThanExisting() {
        long blockNumber = 12L;
        this.service.setLastWatchedBlockNumber(blockNumber);
        EthereumClientConnectorTest.assertEquals((long)blockNumber, (long)this.service.getLastWatchedBlockNumber());
        this.service.setLastWatchedBlockNumber(blockNumber + 1L);
        EthereumClientConnectorTest.assertEquals((long)(blockNumber + 1L), (long)this.service.getLastWatchedBlockNumber());
    }

    @Test
    public void testSetLastWatchedBlockNumberLowerThanExisting() {
        long blockNumber = 12L;
        this.service.setLastWatchedBlockNumber(blockNumber);
        EthereumClientConnectorTest.assertEquals((long)blockNumber, (long)this.service.getLastWatchedBlockNumber());
        this.service.setLastWatchedBlockNumber(blockNumber - 1L);
        EthereumClientConnectorTest.assertEquals((long)blockNumber, (long)this.service.getLastWatchedBlockNumber());
    }

    @Test
    public void testRenewTransactionListeningSubscriptionWhenException() throws Exception {
        this.service.start();
        this.service.connect();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isConnected());
        long lastWatchedBlockNumber = 12L;
        this.service.setLastWatchedBlockNumber(lastWatchedBlockNumber);
        Flowable flowable = (Flowable)Mockito.mock(Flowable.class);
        Mockito.when((Object)this.web3j.ethLogFlowable((EthFilter)ArgumentMatchers.any())).thenReturn((Object)flowable);
        Mockito.when((Object)flowable.subscribe((Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new UnsupportedOperationException()});
        Future future = this.service.renewTransactionListeningSubscription(123L);
        EthereumClientConnectorTest.assertNotNull((Object)future);
        EthereumClientConnectorTest.assertNull(future.get());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.any(), ArgumentMatchers.any(), ArgumentMatchers.any());
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isListeningToBlockchain());
        EthereumClientConnectorTest.assertNotNull((Object)this.service.getConnectionVerifierFuture());
    }

    @Test
    public void testRenewTransactionListeningSubscription_RetryOnSubscriptionError() throws Exception {
        this.service.start();
        this.service.connect();
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isConnected());
        long lastWatchedBlockNumber = 12L;
        this.service.setLastWatchedBlockNumber(lastWatchedBlockNumber);
        Flowable flowable = (Flowable)Mockito.mock(Flowable.class);
        Mockito.when((Object)this.web3j.ethLogFlowable((EthFilter)ArgumentMatchers.any())).thenReturn((Object)flowable);
        Disposable ethFilterSubscribtion = (Disposable)Mockito.mock(Disposable.class);
        AtomicReference onNext = new AtomicReference();
        AtomicReference onError = new AtomicReference();
        Mockito.when((Object)flowable.subscribe((Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any())).thenAnswer(invocation -> {
            onNext.set((Consumer)invocation.getArgument(0, Consumer.class));
            onError.set((Consumer)invocation.getArgument(1, Consumer.class));
            return ethFilterSubscribtion;
        });
        this.subscriptionDisposed = true;
        Mockito.when((Object)ethFilterSubscribtion.isDisposed()).thenAnswer(invocation -> this.subscriptionDisposed);
        ((Disposable)Mockito.doAnswer(invocation -> {
            this.subscriptionDisposed = true;
            return true;
        }).when((Object)ethFilterSubscribtion)).dispose();
        EthereumClientConnectorTest.assertTrue((boolean)ethFilterSubscribtion.isDisposed());
        Future future = this.service.renewTransactionListeningSubscription(0L);
        Disposable disposable = (Disposable)future.get();
        EthereumClientConnectorTest.assertEquals((Object)ethFilterSubscribtion, (Object)disposable);
        ((Flowable)Mockito.verify((Object)flowable, (VerificationMode)Mockito.timeout((long)5000L).times(1))).subscribe((Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ((Consumer)onError.get()).accept((Object)new UnsupportedOperationException());
        EthereumClientConnectorTest.assertTrue((boolean)ethFilterSubscribtion.isDisposed());
        Log log = this.newLog();
        ((Consumer)onNext.get()).accept((Object)log);
        this.subscriptionDisposed = false;
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.wallet.transaction.minedForContract", null, (Object)new ContractTransactionEvent(log.getTransactionHash(), log.getAddress(), log.getData(), log.getTopics(), log.getBlockNumber().longValue()));
        EthereumClientConnectorTest.assertTrue((boolean)this.service.isListeningToBlockchain());
        EthereumClientConnectorTest.assertFalse((boolean)ethFilterSubscribtion.isDisposed());
        this.service.cancelTransactionListeningToBlockchain();
        EthereumClientConnectorTest.assertTrue((boolean)ethFilterSubscribtion.isDisposed());
    }

    private void instantiateService() {
        if (this.service != null && this.service.isConnected()) {
            this.service.stop();
        }
        this.service = new EthereumClientConnector(this.cacheService);
        this.service.setWeb3j(this.web3j);
        this.service.setWeb3jService(this.web3jService);
        this.service.setWebSocketClient(this.webSocketClient);
        this.service.setListenerService(this.listenerService);
        System.setProperty("exo.wallet.blockchain.permanentlyScan", "false");
    }

    private void setAsConnected() {
        this.webSocketConnected = true;
    }

    private void setAsDisconnected() {
        this.webSocketConnected = false;
    }
}

