/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.util;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.exoplatform.common.util.HierarchicalProperty;

public class HierarchicalPropertyTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testQNameEquality() throws Exception {
        QName name1 = new QName("namespace", "localpart", "prefix");
        QName name2 = new QName("namespace", "localpart");
        HierarchicalPropertyTest.assertTrue((boolean)name1.equals(name2));
    }

    public void testPropertyFromQName() throws Exception {
        QName name = new QName("namespace", "localpart", "prefix");
        HierarchicalProperty hp = new HierarchicalProperty(name, "value");
        HierarchicalPropertyTest.assertEquals((Object)name, (Object)hp.getName());
        HierarchicalPropertyTest.assertEquals((String)"prefix:localpart", (String)hp.getStringName());
        HierarchicalPropertyTest.assertEquals((String)"value", (String)hp.getValue());
        HierarchicalPropertyTest.assertTrue((hp.getAttributes().size() == 0 ? 1 : 0) != 0);
        HierarchicalPropertyTest.assertTrue((hp.getChildren().size() == 0 ? 1 : 0) != 0);
    }

    public void testPropertyFromString() throws Exception {
        QName name = new QName("namespace", "localpart", "prefix");
        HierarchicalProperty hp = new HierarchicalProperty("prefix:localpart", "value", "namespace");
        HierarchicalPropertyTest.assertEquals((Object)name, (Object)hp.getName());
        HierarchicalPropertyTest.assertEquals((String)"prefix:localpart", (String)hp.getStringName());
        HierarchicalPropertyTest.assertEquals((String)"value", (String)hp.getValue());
        HierarchicalPropertyTest.assertTrue((hp.getAttributes().size() == 0 ? 1 : 0) != 0);
        HierarchicalPropertyTest.assertTrue((hp.getChildren().size() == 0 ? 1 : 0) != 0);
    }
}

