/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.uri;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.services.rest.uri.UriPattern;
import org.exoplatform.services.rest.uri.UriTemplateParser;

public class UriTemplateParserTest
extends TestCase {
    public void testSimpleRegex() throws Exception {
        try {
            new UriPattern("/a/{x}/{y}/{x}");
            UriTemplateParserTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        UriTemplateParser p = new UriTemplateParser("/a");
        UriTemplateParserTest.assertEquals((String)"/a", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)2, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), new String[0]);
        p = new UriTemplateParser("a");
        UriTemplateParserTest.assertEquals((String)"a", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)1, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), new String[0]);
        p = new UriTemplateParser("/a/");
        UriTemplateParserTest.assertEquals((String)"/a/", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), new String[0]);
        p = new UriTemplateParser("/a/{x}");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{x}/b");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)/b", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)5, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/{x}");
        UriTemplateParserTest.assertEquals((String)"/([^/]+?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)1, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{x}/b/{y}/c");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)/b/([^/]+?)/c", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)8, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y");
        p = new UriTemplateParser("/a/{x}/{y}/b/");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)/([^/]+?)/b/", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)7, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y");
        p = new UriTemplateParser("/a/{x}/{y}/");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)/([^/]+?)/", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)5, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y");
        p = new UriTemplateParser("/{x}/a/{y}/");
        UriTemplateParserTest.assertEquals((String)"/([^/]+?)/a/([^/]+?)/", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)5, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y");
    }

    public void testExtRegex() {
        try {
            new UriTemplateParser("/a/{x:.*}/{y}/{x:.*}");
            UriTemplateParserTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        UriTemplateParser p = new UriTemplateParser("/a/{x:}");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{x : }");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{  x  :  }");
        UriTemplateParserTest.assertEquals((String)"/a/([^/]+?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{x:.+}");
        UriTemplateParserTest.assertEquals((String)"/a/(.+)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/a/{x:(/)?}");
        UriTemplateParserTest.assertEquals((String)"/a/((/)?)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x");
        p = new UriTemplateParser("/{x}/{y:.+}/{z:.*}");
        UriTemplateParserTest.assertEquals((String)"/([^/]+?)/(.+)/(.*)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)3, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y", "z");
        p = new UriTemplateParser("/a /{x}/{y:.+}/{z:.*}");
        UriTemplateParserTest.assertEquals((String)"/a%20/([^/]+?)/(.+)/(.*)", (String)p.getRegex());
        UriTemplateParserTest.assertEquals((int)6, (int)p.getNumberOfLiteralCharacters());
        UriTemplateParserTest.testNames(p.getParameterNames(), "x", "y", "z");
    }

    private static void testNames(List<String> templateVariables, String ... names) {
        UriTemplateParserTest.assertEquals((int)names.length, (int)templateVariables.size());
        int i = 0;
        for (String t : templateVariables) {
            UriTemplateParserTest.assertEquals((String)t, (String)names[i++]);
        }
    }
}

