/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class CookieTest
extends BaseTest {
    public void testToString() {
        Cookie cookie = new Cookie("name", "andrew");
        CookieTest.assertEquals((String)"$Version=1;name=andrew", (String)cookie.toString());
        cookie = new Cookie("name", "andrew", "/exo", "exo.com");
        CookieTest.assertEquals((String)"$Version=1;name=andrew;$Domain=exo.com;$Path=/exo", (String)cookie.toString());
    }

    public void testValueOf() {
        String cookieHeader = "$Version=1;company=exo;$Path=/exo,$Domain=exo.com;";
        Cookie c = Cookie.valueOf((String)cookieHeader);
        CookieTest.assertEquals((int)c.getVersion(), (int)1);
        CookieTest.assertEquals((String)c.getName(), (String)"company");
        CookieTest.assertEquals((String)c.getValue(), (String)"exo");
        CookieTest.assertEquals((String)c.getPath(), (String)"/exo");
        CookieTest.assertEquals((String)c.getDomain(), (String)"exo.com");
    }

    public void testFromString() {
        String cookieHeader = "name=andrew";
        List cookies = HeaderHelper.parseCookies((String)cookieHeader);
        CookieTest.assertEquals((int)cookies.size(), (int)1);
        Cookie c = (Cookie)cookies.get(0);
        CookieTest.assertEquals((int)c.getVersion(), (int)0);
        CookieTest.assertEquals((String)c.getName(), (String)"name");
        CookieTest.assertEquals((String)c.getValue(), (String)"andrew");
        cookieHeader = "company=exo,name=andrew";
        cookies = HeaderHelper.parseCookies((String)cookieHeader);
        CookieTest.assertEquals((int)cookies.size(), (int)2);
        c = (Cookie)cookies.get(0);
        CookieTest.assertEquals((int)c.getVersion(), (int)0);
        CookieTest.assertEquals((String)c.getName(), (String)"company");
        CookieTest.assertEquals((String)c.getValue(), (String)"exo");
        c = (Cookie)cookies.get(1);
        CookieTest.assertEquals((int)c.getVersion(), (int)0);
        CookieTest.assertEquals((String)c.getName(), (String)"name");
        CookieTest.assertEquals((String)c.getValue(), (String)"andrew");
        cookieHeader = "company=exo;name=andrew";
        cookies = HeaderHelper.parseCookies((String)cookieHeader);
        CookieTest.assertEquals((int)cookies.size(), (int)2);
        c = (Cookie)cookies.get(0);
        CookieTest.assertEquals((int)c.getVersion(), (int)0);
        CookieTest.assertEquals((String)c.getName(), (String)"company");
        CookieTest.assertEquals((String)c.getValue(), (String)"exo");
        c = (Cookie)cookies.get(1);
        CookieTest.assertEquals((int)c.getVersion(), (int)0);
        CookieTest.assertEquals((String)c.getName(), (String)"name");
        CookieTest.assertEquals((String)c.getValue(), (String)"andrew");
        cookieHeader = "$Version=1;company=exo;$Path=/exo,$Domain=exo.com;name=andrew";
        cookies = HeaderHelper.parseCookies((String)cookieHeader);
        CookieTest.assertEquals((int)cookies.size(), (int)2);
        c = (Cookie)cookies.get(0);
        CookieTest.assertEquals((int)c.getVersion(), (int)1);
        CookieTest.assertEquals((String)c.getName(), (String)"company");
        CookieTest.assertEquals((String)c.getValue(), (String)"exo");
        CookieTest.assertEquals((String)c.getPath(), (String)"/exo");
        CookieTest.assertEquals((String)c.getDomain(), (String)"exo.com");
        c = (Cookie)cookies.get(1);
        CookieTest.assertEquals((int)c.getVersion(), (int)1);
        CookieTest.assertEquals((String)c.getName(), (String)"name");
        CookieTest.assertEquals((String)c.getValue(), (String)"andrew");
        cookieHeader = "$Version=1;  company=exo;  $Path=/exo, $Domain=exo.com;name=andrew,  $Domain=exo.org";
        cookies = HeaderHelper.parseCookies((String)cookieHeader);
        CookieTest.assertEquals((int)cookies.size(), (int)2);
        c = (Cookie)cookies.get(0);
        CookieTest.assertEquals((int)c.getVersion(), (int)1);
        CookieTest.assertEquals((String)c.getName(), (String)"company");
        CookieTest.assertEquals((String)c.getValue(), (String)"exo");
        CookieTest.assertEquals((String)c.getPath(), (String)"/exo");
        CookieTest.assertEquals((String)c.getDomain(), (String)"exo.com");
        c = (Cookie)cookies.get(1);
        CookieTest.assertEquals((int)c.getVersion(), (int)1);
        CookieTest.assertEquals((String)c.getName(), (String)"name");
        CookieTest.assertEquals((String)c.getValue(), (String)"andrew");
        CookieTest.assertEquals((String)c.getDomain(), (String)"exo.org");
    }

    public void testToString2() {
        NewCookie cookie = new NewCookie("name", "andrew");
        CookieTest.assertEquals((String)"name=andrew;Version=1", (String)cookie.toString());
        cookie = new NewCookie("name", "andrew", "/exo", "exo.com", 0, "sample comment", 1200, true);
        CookieTest.assertEquals((String)"name=andrew;Version=0;Comment=\"sample comment\";Domain=exo.com;Path=/exo;Max-Age=1200;Secure", (String)cookie.toString());
    }
}

