/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.VariantsHandler;

public class VariantsHandlerTest
extends BaseTest {
    public void testVariantHandler() throws Exception {
        List vs = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.valueOf((String)"image/jpeg")}).add().mediaTypes(new MediaType[]{MediaType.valueOf((String)"application/xml")}).languages(new Locale[]{new Locale("en", "us")}).add().mediaTypes(new MediaType[]{MediaType.valueOf((String)"text/xml")}).languages(new Locale[]{new Locale("en")}).add().mediaTypes(new MediaType[]{MediaType.valueOf((String)"text/xml")}).languages(new Locale[]{new Locale("en", "us")}).add().build();
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml", "image/png", "text/html;q=0.9", "text/plain;q=0.8", "application/xml", "*/*;q=0.5"));
        h.putSingle((Object)"Accept-Language", (Object)"en-us,en;q=0.5");
        ContainerRequest r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        Variant v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertEquals((Object)new MediaType("text", "xml"), (Object)v.getMediaType());
        VariantsHandlerTest.assertEquals((Object)new Locale("en", "us"), (Object)v.getLanguage());
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml;q=0.95", "text/html;q=0.9", "application/xml", "image/png", "text/plain;q=0.8", "*/*;q=0.5"));
        h.putSingle((Object)"Accept-Language", (Object)"en-us;q=0.5,en;q=0.7");
        r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertEquals((Object)new MediaType("application", "xml"), (Object)v.getMediaType());
        VariantsHandlerTest.assertEquals((Object)new Locale("en", "us"), (Object)v.getLanguage());
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml", "application/xml", "text/plain;q=0.8", "image/png", "text/html;q=0.9", "*/*;q=0.5"));
        h.putSingle((Object)"Accept-Language", (Object)"en,en-us");
        r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertEquals((Object)new MediaType("text", "xml"), (Object)v.getMediaType());
        VariantsHandlerTest.assertEquals((Object)new Locale("en"), (Object)v.getLanguage());
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml", "application/xml", "image/png", "text/html;q=0.9", "text/plain;q=0.8", "*/*;q=0.5"));
        h.putSingle((Object)"Accept-Language", (Object)"uk");
        r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertEquals((Object)new MediaType("image", "jpeg"), (Object)v.getMediaType());
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml", "application/xml", "image/png", "text/html;q=0.9", "text/plain;q=0.8"));
        h.putSingle((Object)"Accept-Language", (Object)"uk");
        r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertNull((Object)v);
        h.putSingle((Object)"Accept", (Object)VariantsHandlerTest.glue("text/xml", "application/xml", "image/*", "text/html;q=0.9", "text/plain;q=0.8"));
        h.putSingle((Object)"Accept-Language", (Object)"uk");
        r = new ContainerRequest("GET", null, null, null, (MultivaluedMap)h);
        v = VariantsHandler.handleVariants((ContainerRequest)r, (List)vs);
        VariantsHandlerTest.assertEquals((Object)new MediaType("image", "jpeg"), (Object)v.getMediaType());
    }

    private static String glue(String ... s) {
        StringBuffer sb = new StringBuffer();
        for (String _s : s) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(_s);
        }
        return sb.toString();
    }
}

