/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OtherEntityTest
extends BaseTest {
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><data>hello world</data></root>";

    public void testEntityPatameter() throws Exception {
        Resource1 r1 = new Resource1();
        this.registry(r1);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        byte[] data = "to be or not to be".getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/bytes", "", (Map)h, data, null).getStatus());
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/string", "", (Map)h, data, null).getStatus());
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/stream", "", (Map)h, data, null).getStatus());
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/reader", "", (Map)h, data, null).getStatus());
        h.putSingle((Object)"content-type", (Object)"application/xml");
        data = XML_DATA.getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/dom", "", (Map)h, data, null).getStatus());
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/sax", "", (Map)h, data, null).getStatus());
        OtherEntityTest.assertEquals((int)204, (int)this.launcher.service("POST", "/ss", "", (Map)h, data, null).getStatus());
        this.unregistry(r1);
    }

    public void testReturn() throws Exception {
        Resource2 r2 = new Resource2();
        this.registry(r2);
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        h.putSingle((Object)"accept", (Object)"text/plain");
        ContainerResponse response = this.launcher.service("GET", "/bytes", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/octet-stream", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)("" + "to be or not to be".getBytes("UTF-8").length), (String)response.getHttpHeaders().getFirst((Object)"Content-Length").toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        response = this.launcher.service("GET", "/string", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        response = this.launcher.service("GET", "/stream", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/octet-stream", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        response = this.launcher.service("GET", "/reader", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        Pattern pattern = Pattern.compile("(<\\?xml .*\\?>)");
        String xml = pattern.matcher(XML_DATA).replaceFirst("");
        h.putSingle((Object)"accept", (Object)"application/xml");
        response = this.launcher.service("GET", "/dom", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/xml", (String)response.getContentType().toString());
        String result = new String(writer.getBody());
        result = pattern.matcher(result).replaceFirst("");
        OtherEntityTest.assertEquals((String)xml, (String)result);
        response = this.launcher.service("GET", "/sax", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/xml", (String)response.getContentType().toString());
        result = new String(writer.getBody());
        result = pattern.matcher(result).replaceFirst("");
        OtherEntityTest.assertEquals((String)xml, (String)result);
        response = this.launcher.service("GET", "/ss", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/xml", (String)response.getContentType().toString());
        result = new String(writer.getBody());
        result = pattern.matcher(result).replaceFirst("");
        OtherEntityTest.assertEquals((String)xml, (String)result);
        response = this.launcher.service("GET", "/so", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"application/octet-stream", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        response = this.launcher.service("GET", "/response", "", (Map)h, null, (ContainerResponseWriter)writer, null);
        OtherEntityTest.assertEquals((int)200, (int)response.getStatus());
        OtherEntityTest.assertEquals((String)"text/plain", (String)response.getContentType().toString());
        OtherEntityTest.assertEquals((String)("" + "to be or not to be".getBytes("UTF-8").length), (String)response.getHttpHeaders().getFirst((Object)"Content-Length").toString());
        OtherEntityTest.assertEquals((String)"to be or not to be", (String)new String(writer.getBody()));
        this.unregistry(r2);
    }

    @Path(value="/")
    public static class Resource1 {
        @POST
        @Path(value="bytes")
        public void m1(byte[] b) {
            TestCase.assertEquals((String)"to be or not to be", (String)new String(b));
        }

        @POST
        @Path(value="string")
        public void m2(String s) {
            TestCase.assertEquals((String)"to be or not to be", (String)s);
        }

        @POST
        @Path(value="stream")
        public void m3(InputStream in) throws IOException {
            byte[] b = new byte[1024];
            int r = in.read(b);
            TestCase.assertEquals((String)"to be or not to be", (String)new String(b, 0, r));
        }

        @POST
        @Path(value="reader")
        public void m4(Reader rd) throws IOException {
            char[] c = new char[1024];
            int r = rd.read(c);
            TestCase.assertEquals((String)"to be or not to be", (String)new String(c, 0, r));
        }

        @POST
        @Path(value="dom")
        @Consumes(value={"application/xml"})
        public void m5(DOMSource dom) throws Exception {
            Node root = dom.getNode().getFirstChild();
            TestCase.assertEquals((String)"root", (String)root.getNodeName());
            Node data = root.getFirstChild();
            TestCase.assertEquals((String)"data", (String)data.getNodeName());
            TestCase.assertEquals((String)"hello world", (String)data.getFirstChild().getNodeValue());
        }

        @POST
        @Path(value="sax")
        @Consumes(value={"application/xml"})
        public void m6(SAXSource sax) throws Exception {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(sax.getInputSource());
            Element root = doc.getDocumentElement();
            TestCase.assertEquals((String)"root", (String)root.getNodeName());
            Node data = root.getFirstChild();
            TestCase.assertEquals((String)"data", (String)data.getNodeName());
            TestCase.assertEquals((String)"hello world", (String)data.getFirstChild().getNodeValue());
        }

        @POST
        @Path(value="ss")
        @Consumes(value={"application/xml"})
        public void m7(StreamSource ss) throws Exception {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ss.getInputStream());
            Element root = doc.getDocumentElement();
            TestCase.assertEquals((String)"root", (String)root.getNodeName());
            Node data = root.getFirstChild();
            TestCase.assertEquals((String)"data", (String)data.getNodeName());
            TestCase.assertEquals((String)"hello world", (String)data.getFirstChild().getNodeValue());
        }
    }

    @Path(value="/")
    public static class Resource2 {
        @GET
        @Path(value="bytes")
        public byte[] m1() throws Exception {
            return "to be or not to be".getBytes("UTF-8");
        }

        @GET
        @Path(value="string")
        @Produces(value={"text/plain"})
        public String m2() {
            return "to be or not to be";
        }

        @GET
        @Path(value="stream")
        public InputStream m3(InputStream in) throws IOException {
            return new ByteArrayInputStream("to be or not to be".getBytes("UTF-8"));
        }

        @GET
        @Path(value="reader")
        @Produces(value={"text/plain"})
        public Reader m4() throws IOException {
            return new InputStreamReader(new ByteArrayInputStream("to be or not to be".getBytes("UTF-8")));
        }

        @GET
        @Path(value="dom")
        @Produces(value={"application/xml"})
        public DOMSource m5() throws Exception {
            return new DOMSource(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(OtherEntityTest.XML_DATA.getBytes("UTF-8"))));
        }

        @GET
        @Path(value="sax")
        @Produces(value={"application/xml"})
        public SAXSource m6() throws Exception {
            return new SAXSource(new InputSource(new ByteArrayInputStream(OtherEntityTest.XML_DATA.getBytes("UTF-8"))));
        }

        @GET
        @Path(value="ss")
        @Produces(value={"application/xml"})
        public StreamSource m7() throws Exception {
            return new StreamSource(new ByteArrayInputStream(OtherEntityTest.XML_DATA.getBytes("UTF-8")));
        }

        @GET
        @Path(value="so")
        public StreamingOutput m8() throws Exception {
            return new StreamingOutput(this){
                private String data = "to be or not to be";

                public void write(OutputStream out) throws IOException, WebApplicationException {
                    out.write(this.data.getBytes("UTF-8"));
                }
            };
        }

        @GET
        @Path(value="response")
        public Response m9() throws Exception {
            String data = "to be or not to be";
            return Response.ok((Object)data, (String)"text/plain").header("Content-Length", (Object)data.getBytes("UTF-8").length).build();
        }
    }
}

