/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.uri;

import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.exoplatform.services.rest.BaseTest;

public class UriBuilderTest
extends BaseTest {
    public void testReplaceScheme() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").scheme("https").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("https://localhost:8080/a/b/c"), (Object)u);
    }

    public void testReplaceSchemeSpecificPart() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").schemeSpecificPart("//localhost:8080/a/b/c/d").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/d"), (Object)u);
    }

    public void testReplaceUserInfo() {
        URI u = UriBuilder.fromUri((String)"http://exo@localhost:8080/a/b/c").userInfo("andrew").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://andrew@localhost:8080/a/b/c"), (Object)u);
    }

    public void testReplaceHost() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").host("exoplatform.org").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://exoplatform.org:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").host("te st.org").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://te%20st.org:8080/a/b/c"), (Object)u);
    }

    public void testReplacePort() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").port(9000).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:9000/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").port(-1).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost/a/b/c"), (Object)u);
    }

    public void testReplacePath() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").replacePath("/x/y/z").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/x/y/z"), (Object)u);
    }

    public void testReplaceNatrixParam() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c;a=x;b=y;a=z").replaceMatrixParam("a", new Object[]{"b", "c"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c;b=y;a=b;a=c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c;y=b;a=x;b=y;a=z").replaceMatrixParam("a", new Object[]{"b", "c"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c;y=b;b=y;a=b;a=c"), (Object)u);
    }

    public void testReplaceMatrixParams() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c;a=x;b=y").replaceMatrix("x=a;y=b").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c;x=a;y=b"), (Object)u);
    }

    public void testReplaceQueryParam() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y&a=z").replaceQueryParam("a", new Object[]{"b", "c"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?b=y&a=b&a=c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&a=z&b=y").replaceQueryParam("a", new Object[]{"b", "c"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?b=y&a=b&a=c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?b=y&a=x&y=b&a=z").replaceQueryParam("a", new Object[]{"b%20", "c%"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?b=y&y=b&a=b%20&a=c%25"), (Object)u);
    }

    public void testReplaceQuery() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y").replaceQuery("x=a&y=b&zzz=").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?x=a&y=b&zzz"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y").replaceQuery("x=a&zzz=&y=b").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?x=a&zzz&y=b"), (Object)u);
        try {
            u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y").replaceQuery("x=a&=zzz&y=b").build(new Object[0]);
            UriBuilderTest.fail((String)"UriBuilderException should be here");
        }
        catch (UriBuilderException uriBuilderException) {
            // empty catch block
        }
    }

    public void testReplaceFragment() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y#hi").fragment("hel lo").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?a=x&b=y#hel%20lo"), (Object)u);
    }

    public void testReplaceUri() {
        URI u0 = URI.create("http://exo@localhost:8080/a/b/c?a=x&b=y#fragment");
        URI u = UriBuilder.fromUri((URI)u0).uri(URI.create("https://exo@localhost:8080")).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("https://exo@localhost:8080/a/b/c?a=x&b=y#fragment"), (Object)u);
        u = UriBuilder.fromUri((URI)u0).uri(URI.create("http://andrew@localhost:9000")).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://andrew@localhost:9000/a/b/c?a=x&b=y#fragment"), (Object)u);
        u = UriBuilder.fromUri((URI)u0).uri(URI.create("/x/y/z")).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://exo@localhost:8080/x/y/z?a=x&b=y#fragment"), (Object)u);
        u = UriBuilder.fromUri((URI)u0).uri(URI.create("?x=a&b=y")).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://exo@localhost:8080/a/b/c?x=a&b=y#fragment"), (Object)u);
        u = UriBuilder.fromUri((URI)u0).uri(URI.create("#fragment2")).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://exo@localhost:8080/a/b/c?a=x&b=y#fragment2"), (Object)u);
    }

    public void testSchemeSpecificPart() {
        URI u = URI.create("http://exo@localhost:8080/a/b/c?a=x&b=y#fragment");
        URI u2 = UriBuilder.fromUri((URI)u).schemeSpecificPart("//andrew@exoplatform.org:9000/x/y/z?x=a&y=b").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://andrew@exoplatform.org:9000/x/y/z?x=a&y=b#fragment"), (Object)u2);
        u = URI.create("http://exo@localhost:8080/a/b/c?a=x&b=y#fragment");
        u2 = UriBuilder.fromUri((URI)u).schemeSpecificPart("//andrew@exoplatform.org:9000/x /y/z?x= a&y=b").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://andrew@exoplatform.org:9000/x%20/y/z?x=%20a&y=b#fragment"), (Object)u2);
    }

    public void testAppendPath() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080").path("a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").path("a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080").path("/a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").path("/a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c/").path("/").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").path("/").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c/").path("/x/y/z").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/x/y/z"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c%20").path("/x/y /z").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c%20/x/y%20/z"), (Object)u);
    }

    public void testAppendSegments() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080").segment(new String[]{"a/b/c"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").path("a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080").path("/a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").path("/a/b/c").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080").segment(new String[]{"a/b/c", "/x/y/z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/x/y/z"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").segment(new String[]{"a/b/c/", "x/y/z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/x/y/z"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080").segment(new String[]{"/a/b/c/", "/x/y/z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/x/y/z"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/").segment(new String[]{"/a/b/c", "x/y/z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/x/y/z"), (Object)u);
    }

    public void testAppendQueryParams() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c?a=x&b=y").queryParam("c ", new Object[]{"%25z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c?a=x&b=y&c%20=%25z"), (Object)u);
    }

    public void testAppendMatrixParams() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c;a=x;b=y").matrixParam(" c", new Object[]{"%z"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c;a=x;b=y;%20c=%25z"), (Object)u);
    }

    public void testAppendPathAndMatrixParams() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/").path("a").matrixParam("x", new Object[]{" foo"}).matrixParam("y", new Object[]{"%20bar"}).path("b").matrixParam("x", new Object[]{"f o%20o"}).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a;x=%20foo;y=%20bar/b;x=f%20o%20o"), (Object)u);
    }

    public void testResourceAppendPath() throws NoSuchMethodException {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/base").path(R.class).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/base/resource"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/base").path(R.class.getMethod("get", new Class[0])).build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/base/method1"), (Object)u);
    }

    public void testResourceAndMethodAppendPath() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/base").path(R.class, "get").build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/base/resource/method1"), (Object)u);
    }

    public void testTemplates() {
        URI u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").path("/{foo}/{bar}/{baz}/{foo}").build(new Object[]{"%25x", "%y", "z", "wrong"});
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/%2525x/%25y/z/%2525x"), (Object)u);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "%25x");
        m.put("bar", "%y");
        m.put("baz", "z");
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").path("/{foo}/{bar}/{baz}/{foo}").buildFromMap(m);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/%2525x/%25y/z/%2525x"), (Object)u);
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").path("/{foo}/{bar}/{baz}/{foo}").buildFromEncoded(new Object[]{"%25x", "%y", "z", "wrong"});
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/%25x/%25y/z/%25x"), (Object)u);
        m = new HashMap();
        m.put("foo", "%25x");
        m.put("bar", "%y");
        m.put("baz", "z");
        u = UriBuilder.fromUri((String)"http://localhost:8080/a/b/c").path("/{foo}/{bar}/{baz}/{foo}").buildFromEncodedMap(m);
        UriBuilderTest.assertEquals((Object)URI.create("http://localhost:8080/a/b/c/%25x/%25y/z/%25x"), (Object)u);
    }

    public void testClone() {
        UriBuilder u = UriBuilder.fromUri((String)"http://user@localhost:8080/?query#fragment").path("a");
        URI full = u.clone().path("b").build(new Object[0]);
        URI base = u.build(new Object[0]);
        UriBuilderTest.assertEquals((Object)URI.create("http://user@localhost:8080/a?query#fragment"), (Object)base);
        UriBuilderTest.assertEquals((Object)URI.create("http://user@localhost:8080/a/b?query#fragment"), (Object)full);
    }

    @Path(value="resource")
    class R {
        R(UriBuilderTest this$0) {
        }

        @Path(value="method1")
        public void get() {
        }
    }
}

