/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import org.exoplatform.services.rest.BaseTest;
import org.exoplatform.services.rest.impl.header.AcceptMediaType;
import org.exoplatform.services.rest.impl.header.AcceptMediaTypeHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

public class AcceptMediaTypeTest
extends BaseTest {
    public void testValueOf() {
        String mt = "text/xml;charset=utf8;q=0.825";
        AcceptMediaType acceptedMediaType = AcceptMediaType.valueOf((String)mt);
        AcceptMediaTypeTest.assertEquals((String)"text", (String)acceptedMediaType.getType());
        AcceptMediaTypeTest.assertEquals((String)"xml", (String)acceptedMediaType.getSubtype());
        AcceptMediaTypeTest.assertEquals((String)"utf8", (String)((String)acceptedMediaType.getParameters().get("charset")));
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(0.825f), (Object)Float.valueOf(acceptedMediaType.getQvalue()));
        mt = "text/xml;charset=utf8";
        acceptedMediaType = AcceptMediaType.valueOf((String)mt);
        AcceptMediaTypeTest.assertEquals((String)"text", (String)acceptedMediaType.getType());
        AcceptMediaTypeTest.assertEquals((String)"xml", (String)acceptedMediaType.getSubtype());
        AcceptMediaTypeTest.assertEquals((String)"utf8", (String)((String)acceptedMediaType.getParameters().get("charset")));
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedMediaType.getQvalue()));
    }

    public void testFromString() {
        String mt = "text/xml;charset=utf8;q=0.825";
        AcceptMediaTypeHeaderDelegate hd = new AcceptMediaTypeHeaderDelegate();
        AcceptMediaType acceptedMediaType = hd.fromString(mt);
        AcceptMediaTypeTest.assertEquals((String)"text", (String)acceptedMediaType.getType());
        AcceptMediaTypeTest.assertEquals((String)"xml", (String)acceptedMediaType.getSubtype());
        AcceptMediaTypeTest.assertEquals((String)"utf8", (String)((String)acceptedMediaType.getParameters().get("charset")));
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(0.825f), (Object)Float.valueOf(acceptedMediaType.getQvalue()));
        mt = "text/xml;charset=utf8";
        acceptedMediaType = hd.fromString(mt);
        AcceptMediaTypeTest.assertEquals((String)"text", (String)acceptedMediaType.getType());
        AcceptMediaTypeTest.assertEquals((String)"xml", (String)acceptedMediaType.getSubtype());
        AcceptMediaTypeTest.assertEquals((String)"utf8", (String)((String)acceptedMediaType.getParameters().get("charset")));
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(acceptedMediaType.getQvalue()));
    }

    public void testListProducer() {
        List l = HeaderHelper.createAcceptedMediaTypeList(null);
        AcceptMediaTypeTest.assertEquals((int)1, (int)l.size());
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getType(), (String)"*");
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getSubtype(), (String)"*");
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(((AcceptMediaType)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        l = HeaderHelper.createAcceptedMediaTypeList((String)"");
        AcceptMediaTypeTest.assertEquals((int)1, (int)l.size());
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getType(), (String)"*");
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getSubtype(), (String)"*");
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(((AcceptMediaType)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        String mt = "text/xml;  charset=utf8;q=0.825,    text/html;charset=utf8,  text/plain;charset=utf8;q=0.8";
        l = HeaderHelper.createAcceptedMediaTypeList((String)mt);
        AcceptMediaTypeTest.assertEquals((int)3, (int)l.size());
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getType(), (String)"text");
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(0)).getSubtype(), (String)"html");
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(((AcceptMediaType)l.get(0)).getQvalue()), (Object)Float.valueOf(1.0f));
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(1)).getType(), (String)"text");
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(1)).getSubtype(), (String)"xml");
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(((AcceptMediaType)l.get(1)).getQvalue()), (Object)Float.valueOf(0.825f));
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(2)).getType(), (String)"text");
        AcceptMediaTypeTest.assertEquals((String)((AcceptMediaType)l.get(2)).getSubtype(), (String)"plain");
        AcceptMediaTypeTest.assertEquals((Object)Float.valueOf(((AcceptMediaType)l.get(2)).getQvalue()), (Object)Float.valueOf(0.8f));
    }
}

