/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import groovy.lang.GroovyObject;
import java.util.ArrayList;
import org.exoplatform.services.rest.ext.BaseTest;
import org.exoplatform.services.rest.ext.groovy.ExtendedGroovyClassLoader;
import org.exoplatform.services.rest.ext.groovy.GroovyClassLoaderProvider;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

public class ExtendedClassLoaderTest
extends BaseTest {
    public void testParseClasses() throws Exception {
        ExtendedGroovyClassLoader loader = new GroovyClassLoaderProvider().getGroovyClassLoader();
        SourceFile[] sources = new SourceFile[]{new SourceFile(Thread.currentThread().getContextClassLoader().getResource("GMain1.groovy")), new SourceFile(Thread.currentThread().getContextClassLoader().getResource("repo/dependencies/Dep1.groovy"))};
        Class[] classes = loader.parseClasses(sources);
        ExtendedClassLoaderTest.assertEquals((int)2, (int)classes.length);
        ArrayList<String> names = new ArrayList<String>(2);
        for (Class c : classes) {
            names.add(c.getName());
        }
        ExtendedClassLoaderTest.assertTrue((boolean)names.contains("GMain1"));
        ExtendedClassLoaderTest.assertTrue((boolean)names.contains("dependencies.Dep1"));
    }

    public void testParseClasses2() throws Exception {
        ExtendedGroovyClassLoader loader = new GroovyClassLoaderProvider().getGroovyClassLoader(new SourceFolder[]{new SourceFolder(Thread.currentThread().getContextClassLoader().getResource("repo"))});
        SourceFile[] sources = new SourceFile[]{new SourceFile(Thread.currentThread().getContextClassLoader().getResource("GMain1.groovy"))};
        Class[] classes = loader.parseClasses(sources);
        ExtendedClassLoaderTest.assertEquals((int)1, (int)classes.length);
        ArrayList<String> names = new ArrayList<String>(1);
        for (Class c : classes) {
            names.add(c.getName());
        }
        ExtendedClassLoaderTest.assertTrue((boolean)names.contains("GMain1"));
    }

    public void testParseClassWithDependency() throws Exception {
        ExtendedGroovyClassLoader loader = new GroovyClassLoaderProvider().getGroovyClassLoader();
        SourceFile[] sources = new SourceFile[]{new SourceFile(Thread.currentThread().getContextClassLoader().getResource("repo/dependencies/Dep1.groovy"))};
        Class clazz = loader.parseClass(Thread.currentThread().getContextClassLoader().getResourceAsStream("GMain1.groovy"), "GMain1", sources);
        ExtendedClassLoaderTest.assertEquals((String)"GMain1", (String)clazz.getName());
        ExtendedClassLoaderTest.assertEquals((Object)"dependencies.Dep1", (Object)((GroovyObject)clazz.newInstance()).invokeMethod("m0", (Object)new Object[0]));
    }
}

