/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher;

import io.methvin.watcher.hashing.FileHash;
import io.methvin.watcher.hashing.FileHasher;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class PathUtils {
    public static FileHash hash(FileHasher fileHasher, Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return FileHash.directory();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return fileHasher.hash(path);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static <T> SortedMap<Path, T> subMap(SortedMap<Path, T> sortedMap, Path path) {
        return sortedMap.subMap(path, Paths.get(path.toString(), "\uffff"));
    }

    public static SortedMap<Path, FileHash> createHashCodeMap(Path path, FileHasher fileHasher) throws IOException {
        return PathUtils.createHashCodeMap(Collections.singletonList(path), fileHasher);
    }

    public static SortedMap<Path, FileHash> createHashCodeMap(List<Path> list, FileHasher fileHasher) throws IOException {
        ConcurrentSkipListMap<Path, FileHash> concurrentSkipListMap = new ConcurrentSkipListMap<Path, FileHash>();
        if (fileHasher != null) {
            for (Path path : list) {
                for (Path path2 : PathUtils.recursiveListFiles(path)) {
                    FileHash fileHash = PathUtils.hash(fileHasher, path2);
                    if (fileHash == null) continue;
                    concurrentSkipListMap.put(path2, fileHash);
                }
            }
        }
        return concurrentSkipListMap;
    }

    public static void initWatcherState(List<Path> list, FileHasher fileHasher, Map<Path, FileHash> map, Set<Path> set) throws IOException {
        for (Path path2 : list) {
            if (fileHasher == null) {
                PathUtils.recursiveVisitFiles(path2, set::add, path -> {});
                continue;
            }
            PathCallback pathCallback = path -> {
                FileHash fileHash = PathUtils.hash(fileHasher, path);
                if (fileHash != null) {
                    map.put(path, fileHash);
                }
            };
            PathUtils.recursiveVisitFiles(path2, path -> {
                set.add(path);
                pathCallback.call(path);
            }, pathCallback);
        }
    }

    public static Set<Path> recursiveListFiles(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        PathUtils.recursiveVisitFiles(path, hashSet::add, hashSet::add);
        return hashSet;
    }

    public static void recursiveVisitFiles(Path path, final PathCallback pathCallback, final PathCallback pathCallback2) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                pathCallback.call(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                pathCallback2.call(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static <T> WatchEvent<T> cast(WatchEvent<?> watchEvent) {
        return watchEvent;
    }

    static interface PathCallback {
        public void call(Path var1) throws IOException;
    }
}

