/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.NoopHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepFunctionCounter;
import io.micrometer.core.instrument.step.StepFunctionTimer;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.registry.otlp.AggregationTemporality;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpCumulativeCounter;
import io.micrometer.registry.otlp.OtlpCumulativeDistributionSummary;
import io.micrometer.registry.otlp.OtlpCumulativeFunctionCounter;
import io.micrometer.registry.otlp.OtlpCumulativeFunctionTimer;
import io.micrometer.registry.otlp.OtlpCumulativeLongTaskTimer;
import io.micrometer.registry.otlp.OtlpCumulativeTimer;
import io.micrometer.registry.otlp.OtlpMetricConverter;
import io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import io.micrometer.registry.otlp.OtlpStepDistributionSummary;
import io.micrometer.registry.otlp.OtlpStepTimer;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class OtlpMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("otlp-metrics-publisher");
    private static final double[] EMPTY_SLO_WITH_POSITIVE_INF = new double[]{Double.POSITIVE_INFINITY};
    private static final String TELEMETRY_SDK_NAME = "telemetry.sdk.name";
    private static final String TELEMETRY_SDK_LANGUAGE = "telemetry.sdk.language";
    private static final String TELEMETRY_SDK_VERSION = "telemetry.sdk.version";
    private static final Set<String> RESERVED_RESOURCE_ATTRIBUTES = new HashSet<String>(Arrays.asList("telemetry.sdk.name", "telemetry.sdk.language", "telemetry.sdk.version"));
    private final InternalLogger logger = InternalLoggerFactory.getInstance(OtlpMeterRegistry.class);
    private final OtlpConfig config;
    private final HttpSender httpSender;
    private final Resource resource;
    private final AggregationTemporality aggregationTemporality;
    private final TimeUnit baseTimeUnit;
    private volatile long lastMeterRolloverStartTime = -1L;
    @Nullable
    private ScheduledExecutorService meterPollingService;

    public OtlpMeterRegistry() {
        this(OtlpConfig.DEFAULT, Clock.SYSTEM);
    }

    public OtlpMeterRegistry(OtlpConfig config, Clock clock) {
        this(config, clock, (HttpSender)new HttpUrlConnectionSender());
    }

    private OtlpMeterRegistry(OtlpConfig config, Clock clock, HttpSender httpSender) {
        super((PushRegistryConfig)config, clock);
        this.config = config;
        this.baseTimeUnit = config.baseTimeUnit();
        this.httpSender = httpSender;
        this.resource = Resource.newBuilder().addAllAttributes(this.getResourceAttributes()).build();
        this.aggregationTemporality = config.aggregationTemporality();
        this.config().namingConvention(NamingConvention.dot);
        this.start(DEFAULT_THREAD_FACTORY);
    }

    public void start(ThreadFactory threadFactory) {
        super.start(threadFactory);
        if (this.config.enabled() && this.isDelta()) {
            this.meterPollingService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.meterPollingService.scheduleAtFixedRate(this::pollMetersToRollover, this.getInitialDelay(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    protected String startMessage() {
        return String.format("Publishing metrics for %s every %s to %s with resource attributes %s", ((Object)((Object)this)).getClass().getSimpleName(), TimeUtils.format((Duration)this.config.step()), this.config.url(), this.config.resourceAttributes());
    }

    public void stop() {
        super.stop();
        if (this.meterPollingService != null) {
            this.meterPollingService.shutdown();
        }
    }

    protected void publish() {
        for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
            OtlpMetricConverter otlpMetricConverter = new OtlpMetricConverter(this.clock, this.config.step(), this.getBaseTimeUnit(), this.config.aggregationTemporality(), this.config().namingConvention());
            otlpMetricConverter.addMeters(batch);
            try {
                ExportMetricsServiceRequest request = ExportMetricsServiceRequest.newBuilder().addResourceMetrics(ResourceMetrics.newBuilder().setResource(this.resource).addScopeMetrics(ScopeMetrics.newBuilder().addAllMetrics(otlpMetricConverter.getAllMetrics()).build()).build()).build();
                HttpSender.Request.Builder httpRequest = this.httpSender.post(this.config.url()).withContent("application/x-protobuf", request.toByteArray());
                this.config.headers().forEach((arg_0, arg_1) -> ((HttpSender.Request.Builder)httpRequest).withHeader(arg_0, arg_1));
                HttpSender.Response response = httpRequest.send();
                if (response.isSuccessful()) continue;
                this.logger.warn("Failed to publish metrics (context: {}). Server responded with HTTP status code {} and body {}", new Object[]{this.getConfigurationContext(), response.code(), response.body()});
            }
            catch (Throwable e) {
                this.logger.warn("Failed to publish metrics to OTLP receiver (context: {})", (Object)this.getConfigurationContext(), (Object)e);
            }
        }
    }

    private String getConfigurationContext() {
        return "url=" + this.config.url() + ", resource-attributes=" + this.config.resourceAttributes();
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return this.isCumulative() ? new OtlpCumulativeCounter(id, this.clock) : new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return this.isCumulative() ? new OtlpCumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit()) : new OtlpStepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis());
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return this.isCumulative() ? new OtlpCumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, scale, true) : new OtlpStepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis());
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return this.isCumulative() ? new OtlpCumulativeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit(), this.clock) : new StepFunctionTimer(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return this.isCumulative() ? new OtlpCumulativeFunctionCounter<T>(id, obj, countFunction, this.clock) : new StepFunctionCounter(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return this.isCumulative() ? new OtlpCumulativeLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig) : new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
    }

    protected TimeUnit getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public void close() {
        this.stop();
        if (this.config.enabled() && this.isDelta() && !this.isClosed()) {
            if (this.shouldPublishDataForLastStep() && !this.isPublishing()) {
                try {
                    this.publish();
                }
                catch (Throwable e) {
                    this.logger.warn("Unexpected exception thrown while publishing metrics for " + ((Object)((Object)this)).getClass().getSimpleName(), e);
                }
            } else if (this.isPublishing()) {
                this.waitForInProgressScheduledPublish();
            }
            this.getMeters().forEach(this::closingRollover);
        }
        super.close();
    }

    private boolean shouldPublishDataForLastStep() {
        long lastPolledStep;
        if (this.lastMeterRolloverStartTime < 0L) {
            return false;
        }
        long lastPublishedStep = this.getLastScheduledPublishStartTime() / this.config.step().toMillis();
        return lastPublishedStep < (lastPolledStep = this.lastMeterRolloverStartTime / this.config.step().toMillis());
    }

    private void closingRollover(Meter meter) {
        if (meter instanceof StepCounter) {
            ((StepCounter)meter)._closingRollover();
        } else if (meter instanceof StepFunctionCounter) {
            ((StepFunctionCounter)meter)._closingRollover();
        } else if (meter instanceof StepFunctionTimer) {
            ((StepFunctionTimer)meter)._closingRollover();
        } else if (meter instanceof OtlpStepTimer) {
            ((OtlpStepTimer)meter)._closingRollover();
        } else if (meter instanceof OtlpStepDistributionSummary) {
            ((OtlpStepDistributionSummary)meter)._closingRollover();
        }
    }

    void pollMetersToRollover() {
        this.lastMeterRolloverStartTime = this.clock.wallTime();
        this.getMeters().forEach(m -> m.match(gauge -> null, Counter::count, HistogramSupport::takeSnapshot, HistogramSupport::takeSnapshot, meter -> null, meter -> null, FunctionCounter::count, FunctionTimer::count, meter -> null));
    }

    private long getInitialDelay() {
        long stepMillis = this.config.step().toMillis();
        return stepMillis - this.clock.wallTime() % stepMillis + 1L;
    }

    private boolean isCumulative() {
        return this.aggregationTemporality == AggregationTemporality.CUMULATIVE;
    }

    private boolean isDelta() {
        return this.aggregationTemporality == AggregationTemporality.DELTA;
    }

    static KeyValue createKeyValue(String key, String value) {
        return KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build();
    }

    Iterable<KeyValue> getResourceAttributes() {
        boolean serviceNameProvided = false;
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        attributes.add(OtlpMeterRegistry.createKeyValue(TELEMETRY_SDK_NAME, "io.micrometer"));
        attributes.add(OtlpMeterRegistry.createKeyValue(TELEMETRY_SDK_LANGUAGE, "java"));
        String micrometerCoreVersion = MeterRegistry.class.getPackage().getImplementationVersion();
        if (micrometerCoreVersion != null) {
            attributes.add(OtlpMeterRegistry.createKeyValue(TELEMETRY_SDK_VERSION, micrometerCoreVersion));
        }
        for (Map.Entry<String, String> keyValue : this.config.resourceAttributes().entrySet()) {
            if ("service.name".equals(keyValue.getKey())) {
                serviceNameProvided = true;
            }
            if (RESERVED_RESOURCE_ATTRIBUTES.contains(keyValue.getKey())) {
                this.logger.warn("Resource attribute {} is reserved and will be ignored", (Object)keyValue.getKey());
                continue;
            }
            attributes.add(OtlpMeterRegistry.createKeyValue(keyValue.getKey(), keyValue.getValue()));
        }
        if (!serviceNameProvided) {
            attributes.add(OtlpMeterRegistry.createKeyValue("service.name", "unknown_service"));
        }
        return attributes;
    }

    static Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality) {
        return OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, aggregationTemporality, 0L);
    }

    static Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality, long stepMillis) {
        if (distributionStatisticConfig.isPublishingHistogram()) {
            double[] sloWithPositiveInf = OtlpMeterRegistry.getSloWithPositiveInf(distributionStatisticConfig);
            if (AggregationTemporality.isCumulative(aggregationTemporality)) {
                return new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).serviceLevelObjectives(sloWithPositiveInf).percentiles(new double[0]).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), true, false);
            }
            if (AggregationTemporality.isDelta(aggregationTemporality) && stepMillis > 0L) {
                return new OtlpStepBucketHistogram(clock, stepMillis, DistributionStatisticConfig.builder().serviceLevelObjectives(sloWithPositiveInf).build().merge(distributionStatisticConfig), true, false);
            }
        }
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, false);
        }
        return NoopHistogram.INSTANCE;
    }

    static double[] getSloWithPositiveInf(DistributionStatisticConfig distributionStatisticConfig) {
        double[] sloBoundaries = distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        if (sloBoundaries == null || sloBoundaries.length == 0) {
            return EMPTY_SLO_WITH_POSITIVE_INF;
        }
        boolean containsPositiveInf = Arrays.stream(sloBoundaries).anyMatch(value -> value == Double.POSITIVE_INFINITY);
        if (containsPositiveInf) {
            return sloBoundaries;
        }
        double[] sloWithPositiveInf = Arrays.copyOf(sloBoundaries, sloBoundaries.length + 1);
        sloWithPositiveInf[sloWithPositiveInf.length - 1] = Double.POSITIVE_INFINITY;
        return sloWithPositiveInf;
    }
}

