/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.stackdriver;

import com.google.api.Distribution;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Timestamp;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.stackdriver.StackdriverConfig;
import io.micrometer.stackdriver.StackdriverDistributionSummary;
import io.micrometer.stackdriver.StackdriverNamingConvention;
import io.micrometer.stackdriver.StackdriverTimer;
import io.micrometer.stackdriver.UserAgentHeaderProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StackdriverMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("stackdriver-metrics-publisher");
    private static final int TIMESERIES_PER_REQUEST_LIMIT = 200;
    private final InternalLogger logger = InternalLoggerFactory.getInstance(StackdriverMeterRegistry.class);
    private final StackdriverConfig config;
    private long previousBatchEndTime;
    private final Set<String> verifiedDescriptors = ConcurrentHashMap.newKeySet();
    @Nullable
    private MetricServiceSettings metricServiceSettings;
    @Nullable
    MetricServiceClient client;

    public StackdriverMeterRegistry(StackdriverConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, () -> MetricServiceSettings.newBuilder().build());
    }

    private StackdriverMeterRegistry(StackdriverConfig config, Clock clock, ThreadFactory threadFactory, Callable<MetricServiceSettings> metricServiceSettings) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        try {
            this.metricServiceSettings = metricServiceSettings.call();
        }
        catch (Exception e) {
            this.logger.error("unable to create stackdriver service settings", (Throwable)e);
        }
        this.config().namingConvention((NamingConvention)new StackdriverNamingConvention());
        this.previousBatchEndTime = clock.wallTime();
        this.start(threadFactory);
    }

    public static Builder builder(StackdriverConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            if (this.metricServiceSettings == null) {
                this.logger.error("unable to start stackdriver, service settings are not available");
            } else {
                this.shutdownClientIfNecessary(true);
                try {
                    this.client = MetricServiceClient.create((MetricServiceSettings)this.metricServiceSettings);
                    super.start(threadFactory);
                }
                catch (Exception e) {
                    this.logger.error("unable to create stackdriver client", (Throwable)e);
                }
            }
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            this.shutdownClientIfNecessary(false);
        }
    }

    public void stop() {
        super.stop();
    }

    private void shutdownClientIfNecessary(boolean quietly) {
        if (this.client == null) {
            return;
        }
        if (!this.client.isShutdown()) {
            try {
                this.client.shutdownNow();
                boolean terminated = this.client.awaitTermination(10L, TimeUnit.SECONDS);
                if (!terminated) {
                    this.logger.warn("The metric service client failed to terminate within the timeout");
                }
            }
            catch (RuntimeException e) {
                if (quietly) {
                    this.logger.warn("Failed to shutdown the metric service client", (Throwable)e);
                }
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        try {
            this.client.close();
        }
        catch (RuntimeException e) {
            if (quietly) {
                this.logger.warn("Failed to close metric service client", (Throwable)e);
            }
            throw e;
        }
        this.client = null;
    }

    protected void publish() {
        if (this.client == null) {
            return;
        }
        Batch publishBatch = new Batch();
        AtomicLong partitioningCounter = new AtomicLong();
        long partitionSize = Math.min(this.config.batchSize(), 200);
        Collection<List<TimeSeries>> series = this.getMeters().stream().flatMap(meter -> (Stream)meter.match(m -> this.createGauge(publishBatch, (Gauge)m), m -> this.createCounter(publishBatch, (Counter)m), m -> this.createTimer(publishBatch, (Timer)m), m -> this.createSummary(publishBatch, (DistributionSummary)m), m -> this.createLongTaskTimer(publishBatch, (LongTaskTimer)m), m -> this.createTimeGauge(publishBatch, (TimeGauge)m), m -> this.createFunctionCounter(publishBatch, (FunctionCounter)m), m -> this.createFunctionTimer(publishBatch, (FunctionTimer)m), m -> this.createMeter(publishBatch, (Meter)m))).collect(Collectors.groupingBy(o -> partitioningCounter.incrementAndGet() / partitionSize)).values();
        for (List<TimeSeries> partition : series) {
            try {
                CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName("projects/" + this.config.projectId()).addAllTimeSeries(partition).build();
                this.logger.trace("publishing batch to Stackdriver:{}{}", (Object)System.lineSeparator(), (Object)request);
                this.client.createTimeSeries(request);
                this.logger.debug("successfully sent {} TimeSeries to Stackdriver", (Object)partition.size());
            }
            catch (ApiException e) {
                this.logger.warn("failed to send metrics to Stackdriver", (Throwable)e);
            }
        }
    }

    Stream<TimeSeries> createMeter(Batch batch, Meter m) {
        return StreamSupport.stream(m.measure().spliterator(), false).map(ms -> batch.createTimeSeries(m, ms.getValue(), ms.getStatistic().getTagValueRepresentation(), MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createFunctionTimer(Batch batch, FunctionTimer timer) {
        long count = (long)timer.count();
        Distribution.Builder distribution = Distribution.newBuilder().setMean(timer.mean(this.getBaseTimeUnit())).setCount(count).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addBounds(0.0).build())).addBucketCounts(0L).addBucketCounts(count);
        return Stream.of(batch.createTimeSeries((Meter)timer, distribution.build(), null, MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createFunctionCounter(Batch batch, FunctionCounter functionCounter) {
        return Stream.of(batch.createTimeSeries((Meter)functionCounter, functionCounter.count(), null, this.config.useSemanticMetricTypes() ? MetricDescriptor.MetricKind.CUMULATIVE : MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createTimeGauge(Batch batch, TimeGauge timeGauge) {
        return Stream.of(batch.createTimeSeries((Meter)timeGauge, timeGauge.value(this.getBaseTimeUnit()), null, MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createSummary(Batch batch, DistributionSummary summary) {
        return batch.createTimeSeries((HistogramSupport)summary, false);
    }

    Stream<TimeSeries> createTimer(Batch batch, Timer timer) {
        return batch.createTimeSeries((HistogramSupport)timer, true);
    }

    Stream<TimeSeries> createGauge(Batch batch, Gauge gauge) {
        return Stream.of(batch.createTimeSeries((Meter)gauge, gauge.value(), null, MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createCounter(Batch batch, Counter counter) {
        return Stream.of(batch.createTimeSeries((Meter)counter, counter.count(), null, this.config.useSemanticMetricTypes() ? MetricDescriptor.MetricKind.CUMULATIVE : MetricDescriptor.MetricKind.GAUGE));
    }

    Stream<TimeSeries> createLongTaskTimer(Batch batch, LongTaskTimer longTaskTimer) {
        return Stream.of(batch.createTimeSeries((Meter)longTaskTimer, longTaskTimer.activeTasks(), "activeTasks", MetricDescriptor.MetricKind.GAUGE), batch.createTimeSeries((Meter)longTaskTimer, longTaskTimer.duration(this.getBaseTimeUnit()), "duration", MetricDescriptor.MetricKind.GAUGE));
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new StackdriverDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis());
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new StackdriverTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis());
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private Timestamp buildTimestamp(long timeMs) {
        return Timestamp.newBuilder().setSeconds(timeMs / 1000L).setNanos((int)(timeMs % 1000L) * 1000000).build();
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final StackdriverConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = StackdriverMeterRegistry.access$000();
        private Callable<MetricServiceSettings> metricServiceSettings;

        Builder(StackdriverConfig config) {
            this.config = config;
            this.metricServiceSettings = () -> {
                MetricServiceSettings.Builder builder = MetricServiceSettings.newBuilder();
                if (config.credentials() != null) {
                    builder.setCredentialsProvider(config.credentials());
                }
                builder.setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider("stackdriver"));
                return builder.build();
            };
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder metricServiceSettings(Callable<MetricServiceSettings> metricServiceSettings) {
            this.metricServiceSettings = metricServiceSettings;
            return this;
        }

        public StackdriverMeterRegistry build() {
            return new StackdriverMeterRegistry(this.config, this.clock, this.threadFactory, this.metricServiceSettings);
        }
    }

    class Batch {
        private final Timestamp startTime;
        private final Timestamp endTime;

        Batch() {
            long wallTime = StackdriverMeterRegistry.this.clock.wallTime();
            this.startTime = StackdriverMeterRegistry.this.buildTimestamp(StackdriverMeterRegistry.this.previousBatchEndTime + 1L);
            this.endTime = StackdriverMeterRegistry.this.buildTimestamp(wallTime);
            StackdriverMeterRegistry.this.previousBatchEndTime = wallTime;
        }

        TimeSeries createTimeSeries(Meter meter, double value, @Nullable String statistic, MetricDescriptor.MetricKind metricKind) {
            return this.createTimeSeries(meter, TypedValue.newBuilder().setDoubleValue(value).build(), MetricDescriptor.ValueType.DOUBLE, statistic, metricKind);
        }

        TimeSeries createTimeSeries(Meter meter, long value, @Nullable String statistic, MetricDescriptor.MetricKind metricKind) {
            return this.createTimeSeries(meter, TypedValue.newBuilder().setInt64Value(value).build(), MetricDescriptor.ValueType.INT64, statistic, metricKind);
        }

        TimeSeries createTimeSeries(Meter meter, Distribution distribution, @Nullable String statistic, MetricDescriptor.MetricKind metricKind) {
            return this.createTimeSeries(meter, TypedValue.newBuilder().setDistributionValue(distribution).build(), MetricDescriptor.ValueType.DISTRIBUTION, statistic, metricKind);
        }

        Stream<TimeSeries> createTimeSeries(HistogramSupport histogramSupport, boolean timeDomain) {
            HistogramSnapshot snapshot = histogramSupport.takeSnapshot();
            return Stream.concat(Stream.of(this.createTimeSeries((Meter)histogramSupport, this.distribution(snapshot, timeDomain), null, MetricDescriptor.MetricKind.GAUGE), this.createTimeSeries((Meter)histogramSupport, timeDomain ? snapshot.max(StackdriverMeterRegistry.this.getBaseTimeUnit()) : snapshot.max(), "max", MetricDescriptor.MetricKind.GAUGE), this.createTimeSeries((Meter)histogramSupport, snapshot.count(), "count", StackdriverMeterRegistry.this.config.useSemanticMetricTypes() ? MetricDescriptor.MetricKind.CUMULATIVE : MetricDescriptor.MetricKind.GAUGE)), Arrays.stream(snapshot.percentileValues()).map(valueAtP -> this.createTimeSeries((Meter)histogramSupport, timeDomain ? valueAtP.value(StackdriverMeterRegistry.this.getBaseTimeUnit()) : valueAtP.value(), "p" + DoubleFormat.wholeOrDecimal((double)(valueAtP.percentile() * 100.0)), MetricDescriptor.MetricKind.GAUGE)));
        }

        private TimeSeries createTimeSeries(Meter meter, TypedValue typedValue, MetricDescriptor.ValueType valueType, @Nullable String statistic, MetricDescriptor.MetricKind metricKind) {
            Meter.Id id = meter.getId();
            if (StackdriverMeterRegistry.this.client != null) {
                this.createMetricDescriptorIfNecessary(StackdriverMeterRegistry.this.client, id, valueType, statistic, metricKind);
            }
            String metricType = this.metricType(id, statistic);
            Map<String, String> metricLabels = StackdriverMeterRegistry.this.getConventionTags(id).stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
            return TimeSeries.newBuilder().setMetric(Metric.newBuilder().setType(metricType).putAllLabels(metricLabels).build()).setResource(MonitoredResource.newBuilder().setType(StackdriverMeterRegistry.this.config.resourceType()).putLabels("project_id", StackdriverMeterRegistry.this.config.projectId()).putAllLabels(StackdriverMeterRegistry.this.config.resourceLabels()).build()).setMetricKind(metricKind).setValueType(valueType).addPoints(Point.newBuilder().setInterval(this.interval(metricKind)).setValue(typedValue).build()).build();
        }

        private void createMetricDescriptorIfNecessary(MetricServiceClient client, Meter.Id id, MetricDescriptor.ValueType valueType, @Nullable String statistic, MetricDescriptor.MetricKind metricKind) {
            if (StackdriverMeterRegistry.this.verifiedDescriptors.isEmpty()) {
                this.prePopulateVerifiedDescriptors();
            }
            String metricType = this.metricType(id, statistic);
            if (!StackdriverMeterRegistry.this.verifiedDescriptors.contains(metricType)) {
                MetricDescriptor descriptor = MetricDescriptor.newBuilder().setType(metricType).setDescription(id.getDescription() == null ? "" : id.getDescription()).setMetricKind(metricKind).setValueType(valueType).build();
                ProjectName name = ProjectName.of((String)StackdriverMeterRegistry.this.config.projectId());
                CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name.toString()).setMetricDescriptor(descriptor).build();
                StackdriverMeterRegistry.this.logger.trace("creating metric descriptor:{}{}", (Object)System.lineSeparator(), (Object)request);
                try {
                    client.createMetricDescriptor(request);
                    StackdriverMeterRegistry.this.verifiedDescriptors.add(metricType);
                }
                catch (ApiException e) {
                    StackdriverMeterRegistry.this.logger.warn("failed to create metric descriptor in Stackdriver for meter " + id, (Throwable)e);
                }
            }
        }

        private void prePopulateVerifiedDescriptors() {
            try {
                if (StackdriverMeterRegistry.this.client != null) {
                    String prefix = this.metricType(new Meter.Id("", Tags.empty(), null, null, Meter.Type.OTHER), null);
                    String filter = String.format("metric.type = starts_with(\"%s\")", prefix);
                    String projectName = "projects/" + StackdriverMeterRegistry.this.config.projectId();
                    ListMetricDescriptorsRequest listMetricDescriptorsRequest = ListMetricDescriptorsRequest.newBuilder().setName(projectName).setFilter(filter).build();
                    MetricServiceClient.ListMetricDescriptorsPagedResponse listMetricDescriptorsPagedResponse = StackdriverMeterRegistry.this.client.listMetricDescriptors(listMetricDescriptorsRequest);
                    listMetricDescriptorsPagedResponse.iterateAll().forEach(metricDescriptor -> StackdriverMeterRegistry.this.verifiedDescriptors.add(metricDescriptor.getType()));
                    StackdriverMeterRegistry.this.logger.trace("Pre populated verified descriptors for project: {}, with filter: {}, existing metrics: {}", new Object[]{projectName, filter, StackdriverMeterRegistry.this.verifiedDescriptors});
                }
            }
            catch (Exception e) {
                StackdriverMeterRegistry.this.logger.warn("Failed to pre populate verified descriptors for {}", (Object)StackdriverMeterRegistry.this.config.projectId(), (Object)e);
            }
        }

        private String metricType(Meter.Id id, @Nullable String statistic) {
            StringBuilder metricType = new StringBuilder(StackdriverMeterRegistry.this.config.metricTypePrefix()).append(StackdriverMeterRegistry.this.getConventionName(id));
            if (statistic != null) {
                metricType.append('/').append(statistic);
            }
            return metricType.toString();
        }

        private TimeInterval interval(MetricDescriptor.MetricKind metricKind) {
            TimeInterval.Builder builder = TimeInterval.newBuilder().setEndTime(this.endTime);
            if (metricKind == MetricDescriptor.MetricKind.CUMULATIVE) {
                builder.setStartTime(this.startTime);
            }
            return builder.build();
        }

        Distribution distribution(HistogramSnapshot snapshot, boolean timeDomain) {
            List<Double> bucketBoundaries;
            int endIndex;
            CountAtBucket[] histogram = snapshot.histogramCounts();
            List<Long> bucketCounts = new ArrayList<Long>();
            long cumulativeCount = 0L;
            for (CountAtBucket countAtBucket2 : histogram) {
                long count = (long)countAtBucket2.count();
                bucketCounts.add(count);
                cumulativeCount += count;
            }
            if (bucketCounts.size() > 1 && (Long)bucketCounts.get(endIndex = bucketCounts.size() - 2) == 0L) {
                int lastNonZeroIndex = 0;
                for (int i = endIndex - 1; i >= 0; --i) {
                    if ((Long)bucketCounts.get(i) <= 0L) continue;
                    lastNonZeroIndex = i;
                    break;
                }
                Long infCount = (Long)bucketCounts.get(bucketCounts.size() - 1);
                bucketCounts = bucketCounts.subList(0, lastNonZeroIndex + 1);
                bucketCounts.add(infCount);
            }
            if (bucketCounts.isEmpty()) {
                bucketCounts.add(0L);
            }
            if ((bucketBoundaries = (List<Double>)Arrays.stream(histogram).map(countAtBucket -> timeDomain ? countAtBucket.bucket(StackdriverMeterRegistry.this.getBaseTimeUnit()) : countAtBucket.bucket()).collect(Collectors.toCollection(ArrayList::new))).size() == 1) {
                bucketBoundaries.remove(Double.POSITIVE_INFINITY);
            }
            if (bucketBoundaries.size() != bucketCounts.size() - 1) {
                bucketBoundaries = bucketBoundaries.subList(0, bucketCounts.size() - 1);
            }
            if (bucketBoundaries.isEmpty()) {
                bucketBoundaries.add(0.0);
            }
            double mean = cumulativeCount == 0L ? 0.0 : (timeDomain ? snapshot.mean(StackdriverMeterRegistry.this.getBaseTimeUnit()) : snapshot.mean());
            return Distribution.newBuilder().setMean(mean).setCount(cumulativeCount).setBucketOptions(Distribution.BucketOptions.newBuilder().setExplicitBuckets(Distribution.BucketOptions.Explicit.newBuilder().addAllBounds(bucketBoundaries).build()).build()).addAllBucketCounts(bucketCounts).build();
        }
    }
}

