/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.io.netty.handler.codec.socksx.v5;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.micrometer.shaded.io.netty.handler.codec.DecoderException;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResult;
import io.micrometer.shaded.io.netty.handler.codec.socksx.v5.DefaultSocks5PrivateAuthRequest;
import io.micrometer.shaded.io.netty.util.internal.EmptyArrays;
import java.util.List;

public final class Socks5PrivateAuthRequestDecoder
extends ByteToMessageDecoder {
    private boolean decoded;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (this.decoded) {
                int readableBytes = in.readableBytes();
                if (readableBytes > 0) {
                    out.add(in.readRetainedSlice(readableBytes));
                }
                return;
            }
            if (in.readableBytes() < 2) {
                return;
            }
            int startOffset = in.readerIndex();
            byte version = in.getByte(startOffset);
            if (version != 1) {
                throw new DecoderException("unsupported subnegotiation version: " + version + " (expected: 1)");
            }
            short tokenLength = in.getUnsignedByte(startOffset + 1);
            if (in.readableBytes() < 2 + tokenLength) {
                return;
            }
            in.skipBytes(2);
            byte[] token = new byte[tokenLength];
            in.readBytes(token);
            out.add(new DefaultSocks5PrivateAuthRequest(token));
            this.decoded = true;
        }
        catch (Exception e) {
            this.fail(out, e);
        }
    }

    private void fail(List<Object> out, Exception cause) {
        if (!(cause instanceof DecoderException)) {
            cause = new DecoderException(cause);
        }
        this.decoded = true;
        DefaultSocks5PrivateAuthRequest m = new DefaultSocks5PrivateAuthRequest(EmptyArrays.EMPTY_BYTES);
        m.setDecoderResult(DecoderResult.failure(cause));
        out.add(m);
    }
}

