/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.shaded.reactor.core.publisher.FluxSink;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdPollable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import org.jspecify.annotations.Nullable;

public class StatsdGauge<T>
extends AbstractMeter
implements Gauge,
StatsdPollable {
    private final StatsdLineBuilder lineBuilder;
    private final FluxSink<String> sink;
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;
    private final AtomicReference<Double> lastValue = new AtomicReference<Double>(Double.NaN);
    private final boolean alwaysPublish;

    StatsdGauge(Meter.Id id, StatsdLineBuilder lineBuilder, FluxSink<String> sink, @Nullable T obj, ToDoubleFunction<T> value, boolean alwaysPublish) {
        super(id);
        this.lineBuilder = lineBuilder;
        this.sink = sink;
        this.ref = new WeakReference<T>(obj);
        this.value = value;
        this.alwaysPublish = alwaysPublish;
    }

    public double value() {
        Object obj = this.ref.get();
        return obj != null ? this.value.applyAsDouble(obj) : Double.NaN;
    }

    @Override
    public void poll() {
        double val = this.value();
        if (Double.isFinite(val) && (this.alwaysPublish || this.lastValue.getAndSet(val) != val)) {
            this.sink.next(this.lineBuilder.gauge(val));
        }
    }
}

