/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.baggage.BaggageField;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageInScope;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BraveBaggageManager
implements Closeable,
BaggageManager {
    private static final Map<String, BraveBaggageInScope> CACHE = new ConcurrentHashMap<String, BraveBaggageInScope>();

    public Map<String, String> getAllBaggage() {
        return BaggageField.getAllValues();
    }

    public Baggage getBaggage(String name) {
        return this.createBaggage(name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        BaggageField baggageField = BaggageField.getByName((brave.propagation.TraceContext)BraveTraceContext.toBrave(traceContext), (String)name);
        if (baggageField == null) {
            return null;
        }
        return new BraveBaggageInScope(baggageField);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.baggage(name);
    }

    private BraveBaggageInScope baggage(String name) {
        return CACHE.computeIfAbsent(name, s -> new BraveBaggageInScope(BaggageField.create((String)s)));
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        return this.baggage(name).set(value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.baggage(name).makeCurrent(value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.baggage(name).makeCurrent(traceContext, value);
    }

    @Override
    public void close() {
        CACHE.clear();
    }
}

