/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.context.scope.refresh.RefreshScope;
import io.micronaut.test.annotation.AnnotationUtils;
import io.micronaut.test.annotation.MicronautTestValue;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.test.support.TestPropertyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractMicronautExtension<C>
implements TestExecutionListener {
    public static final String TEST_ROLLBACK = "micronaut.test.rollback";
    public static final String TEST_TRANSACTIONAL = "micronaut.test.transactional";
    public static final String TEST_TRANSACTION_MODE = "micronaut.test.transaction-mode";
    public static final String DISABLED_MESSAGE = "Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.";
    public static final String MISCONFIGURED_MESSAGE = "@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/";
    public static final String TEST_PROPERTY_SOURCE = "test-properties";
    private static Map<String, PropertySourceLoader> loaderMap;
    protected ApplicationContext applicationContext;
    protected EmbeddedApplication embeddedApplication;
    protected RefreshScope refreshScope;
    protected BeanDefinition<?> specDefinition;
    protected Map<String, Object> testProperties = new LinkedHashMap<String, Object>();
    protected Map<String, Object> oldValues = new LinkedHashMap<String, Object>();
    private MicronautTestValue testAnnotationValue;
    private ApplicationContextBuilder builder = ApplicationContext.build();
    private List<TestExecutionListener> listeners;

    @Override
    public void beforeTestExecution(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::beforeTestExecution, testContext, false);
    }

    @Override
    public void beforeCleanupTest(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::beforeCleanupTest, testContext, false);
    }

    @Override
    public void afterCleanupTest(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::afterCleanupTest, testContext, true);
    }

    @Override
    public void afterTestExecution(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::afterTestExecution, testContext, true);
    }

    @Override
    public void beforeTestClass(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::beforeTestClass, testContext, false);
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::afterTestClass, testContext, true);
    }

    @Override
    public void beforeSetupTest(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::beforeSetupTest, testContext, false);
    }

    @Override
    public void afterSetupTest(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::afterSetupTest, testContext, true);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::beforeTestMethod, testContext, false);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        this.fireListeners(TestExecutionListener::afterTestMethod, testContext, true);
    }

    private void fireListeners(TestListenerCallback callback, TestContext testContext, boolean reverse) throws Exception {
        block4: {
            if (this.listeners == null) break block4;
            if (reverse) {
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    callback.apply(this.listeners.get(i), testContext);
                }
            } else {
                for (TestExecutionListener listener : this.listeners) {
                    callback.apply(listener, testContext);
                }
            }
        }
    }

    protected void beforeClass(C context, Class<?> testClass, @Nullable MicronautTestValue testAnnotationValue) {
        if (testAnnotationValue != null) {
            String[] environments;
            Object[] cb = testAnnotationValue.contextBuilder();
            if (ArrayUtils.isNotEmpty((Object[])cb)) {
                this.builder = (ApplicationContextBuilder)InstantiationUtils.instantiate((Class)cb[0]);
            }
            this.testAnnotationValue = testAnnotationValue;
            Package aPackage = testClass.getPackage();
            this.builder.packages(new String[]{aPackage.getName()});
            List<Property> ps = AnnotationUtils.findRepeatableAnnotations(testClass, Property.class);
            for (Property property : ps) {
                this.testProperties.put(property.name(), property.value());
            }
            Object[] propertySources = testAnnotationValue.propertySources();
            if (ArrayUtils.isNotEmpty((Object[])propertySources)) {
                Map<String, PropertySourceLoader> loaderMap = this.readPropertySourceLoaderMap();
                ResourceResolver resourceResolver = new ResourceResolver();
                for (Object propertySource : propertySources) {
                    Optional resourceAsStream;
                    InputStream inputStream;
                    String ext = NameUtils.extension((String)propertySource);
                    if (!StringUtils.isNotEmpty((CharSequence)ext)) continue;
                    String filename = NameUtils.filename((String)propertySource);
                    PropertySourceLoader loader = loaderMap.get(ext);
                    if (loader == null || (inputStream = (resourceAsStream = resourceResolver.getResourceAsStream((String)propertySource)).orElse(testClass.getResourceAsStream((String)propertySource))) == null) continue;
                    try {
                        Map properties = loader.read(filename, inputStream);
                        this.builder.propertySources(new PropertySource[]{PropertySource.of((String)filename, (Map)properties)});
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading property source reference for @MicronautTest: " + filename);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (TestPropertyProvider.class.isAssignableFrom(testClass)) {
                this.resolveTestProperties(context, testAnnotationValue, this.testProperties);
            }
            this.testProperties.put("micronaut.test.active.spec", aPackage.getName() + "." + testClass.getSimpleName());
            this.testProperties.put("micronaut.test.active.spec.clazz", testClass);
            this.testProperties.put(TEST_ROLLBACK, String.valueOf(testAnnotationValue.rollback()));
            this.testProperties.put(TEST_TRANSACTIONAL, String.valueOf(testAnnotationValue.transactional()));
            this.testProperties.put(TEST_TRANSACTION_MODE, String.valueOf((Object)testAnnotationValue.transactionMode()));
            Class<?> application = testAnnotationValue.application();
            if (application != Void.TYPE) {
                this.builder.mainClass(application);
            }
            if ((environments = testAnnotationValue.environments()).length == 0) {
                environments = new String[]{"test"};
            }
            this.builder.packages(testAnnotationValue.packages()).environments(environments);
            PropertySource testPropertySource = PropertySource.of((String)TEST_PROPERTY_SOURCE, this.testProperties);
            this.builder.propertySources(new PropertySource[]{testPropertySource});
            this.postProcessBuilder(this.builder);
            this.applicationContext = this.builder.build();
            this.startApplicationContext();
            this.specDefinition = this.applicationContext.findBeanDefinition(testClass).orElse(null);
            if (testAnnotationValue.startApplication() && this.applicationContext.containsBean(EmbeddedApplication.class)) {
                this.embeddedApplication = (EmbeddedApplication)this.applicationContext.getBean(EmbeddedApplication.class);
                this.embeddedApplication.start();
            }
            this.refreshScope = this.applicationContext.findBean(RefreshScope.class).orElse(null);
        }
    }

    protected void postProcessBuilder(ApplicationContextBuilder builder) {
    }

    protected abstract void resolveTestProperties(C var1, MicronautTestValue var2, Map<String, Object> var3);

    protected void beforeEach(C context, @Nullable Object testInstance, @Nullable AnnotatedElement method, List<Property> propertyAnnotations) {
        int testCount = (Integer)this.testProperties.compute("micronaut.test.count", (k, oldCount) -> (Integer)(oldCount != null ? oldCount : Integer.valueOf(0)) + 1);
        if (method != null) {
            if (propertyAnnotations != null && !propertyAnnotations.isEmpty()) {
                for (Property property : propertyAnnotations) {
                    String name = property.name();
                    this.oldValues.put(name, this.testProperties.put(name, property.value()));
                }
            } else {
                this.oldValues.forEach((k, v) -> {
                    if (v == null) {
                        this.testProperties.remove(k);
                    } else {
                        this.testProperties.put((String)k, v);
                    }
                });
            }
            if (this.testAnnotationValue.rebuildContext() && testCount > 1) {
                this.stopEmbeddedApplication();
                if (this.applicationContext.isRunning()) {
                    this.applicationContext.stop();
                }
                this.applicationContext = this.builder.build();
                this.startApplicationContext();
                this.startEmbeddedApplication();
            } else if (!this.oldValues.isEmpty()) {
                Map diff = this.applicationContext.getEnvironment().refreshAndDiff();
                this.refreshScope.onRefreshEvent(new RefreshEvent(diff));
            }
        }
        if (testInstance != null && this.applicationContext != null) {
            if (this.refreshScope != null) {
                this.refreshScope.onRefreshEvent(new RefreshEvent(Collections.singletonMap("micronaut.test.spock.active.mocks", "changed")));
            }
            this.applicationContext.inject(testInstance);
            this.alignMocks(context, testInstance);
        }
    }

    protected void afterClass(C context) {
        this.stopEmbeddedApplication();
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.applicationContext.stop();
        }
        this.embeddedApplication = null;
        this.applicationContext = null;
    }

    public void afterEach(C context) throws Exception {
        if (this.refreshScope != null && !this.oldValues.isEmpty()) {
            this.oldValues.forEach((k, v) -> {
                if (v == null) {
                    this.testProperties.remove(k);
                } else {
                    this.testProperties.put((String)k, v);
                }
            });
            Map diff = this.applicationContext.getEnvironment().refreshAndDiff();
            this.refreshScope.onRefreshEvent(new RefreshEvent(diff));
        }
        this.oldValues.clear();
    }

    protected void startApplicationContext() {
        this.applicationContext.start();
        this.listeners = new ArrayList<TestExecutionListener>(this.applicationContext.getBeansOfType(TestExecutionListener.class));
    }

    protected boolean isTestSuiteBeanPresent(Class<?> requiredTestClass) {
        return ClassUtils.isPresent((String)(requiredTestClass.getPackage().getName() + ".$" + requiredTestClass.getSimpleName() + "Definition"), (ClassLoader)requiredTestClass.getClassLoader());
    }

    protected abstract void alignMocks(C var1, Object var2);

    private Map<String, PropertySourceLoader> readPropertySourceLoaderMap() {
        Map<String, PropertySourceLoader> loaderMap = AbstractMicronautExtension.loaderMap;
        if (loaderMap == null) {
            AbstractMicronautExtension.loaderMap = loaderMap = new HashMap<String, PropertySourceLoader>();
            SoftServiceLoader loaders = SoftServiceLoader.load(PropertySourceLoader.class);
            for (ServiceDefinition loader : loaders) {
                if (!loader.isPresent()) continue;
                PropertySourceLoader psl = (PropertySourceLoader)loader.load();
                Set extensions = psl.getExtensions();
                for (String extension : extensions) {
                    loaderMap.put(extension, psl);
                }
            }
        }
        return loaderMap;
    }

    private void startEmbeddedApplication() {
        if (this.embeddedApplication != null) {
            this.embeddedApplication.start();
        }
    }

    private void stopEmbeddedApplication() {
        if (this.embeddedApplication != null) {
            this.embeddedApplication.stop();
        }
    }

    @FunctionalInterface
    private static interface TestListenerCallback {
        public void apply(TestExecutionListener var1, TestContext var2) throws Exception;
    }
}

