/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.system;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.SystemChange;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.driver.DriverLegaciable;
import io.mongock.driver.api.driver.DriverSystemUpdatable;
import io.mongock.runner.core.executor.ChangeExecutorBase;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.internal.ChangeLogItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SystemUpdateExecutor<CONFIG extends MongockConfiguration>
extends ChangeExecutorBase<CONFIG> {
    private static final Logger logger = LoggerFactory.getLogger(SystemUpdateExecutor.class);
    private static final String SYSTEM_CHANGES_DEFAULT_AUTHOR = "mongock";
    private final List<String> basePackages;

    public SystemUpdateExecutor(String executionId, ConnectionDriver driver, ChangeLogServiceBase changeLogService, ChangeLogRuntime changeLogRuntime, CONFIG config, List<String> basePackages) {
        super(executionId, changeLogService, driver, changeLogRuntime, null, null, config.getServiceIdentifier(), false, config.getTransactionEnabled(), TransactionStrategy.CHANGE_UNIT, config);
        this.basePackages = basePackages;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Boolean executeMigration() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void prepareChangeLogService() {
        DriverLegaciable legaciableDriver;
        DriverSystemUpdatable driverSystemUpdatable;
        ArrayList<String> changeLogsScanPackage = new ArrayList<String>();
        if (this.basePackages != null) {
            changeLogsScanPackage.addAll(this.basePackages);
        }
        if ((driverSystemUpdatable = this.getDriverSystemUpdatable(this.driver)) != null && driverSystemUpdatable.getSystemUpdateChangesPackage() != null && !driverSystemUpdatable.getSystemUpdateChangesPackage().trim().isEmpty()) {
            changeLogsScanPackage.add(driverSystemUpdatable.getSystemUpdateChangesPackage());
        }
        if (((MongockConfiguration)this.config).getLegacyMigration() != null && (legaciableDriver = this.getDriverLegaciable(this.driver)) != null) {
            changeLogsScanPackage.add(legaciableDriver.getLegacyMigrationChangeLogClass(((MongockConfiguration)this.config).getLegacyMigration().isRunAlways()).getPackage().getName());
        }
        this.changeLogService.reset();
        this.changeLogService.setChangeLogsBasePackageList(changeLogsScanPackage);
        this.changeLogService.setDefaultMigrationAuthor(SYSTEM_CHANGES_DEFAULT_AUTHOR);
    }

    private DriverSystemUpdatable getDriverSystemUpdatable(ConnectionDriver driver) {
        return driver != null && DriverSystemUpdatable.class.isAssignableFrom(driver.getClass()) ? (DriverSystemUpdatable)driver : null;
    }

    private DriverLegaciable getDriverLegaciable(ConnectionDriver driver) {
        return driver != null && DriverLegaciable.class.isAssignableFrom(driver.getClass()) ? (DriverLegaciable)driver : null;
    }

    @Override
    protected void validateChangeLog(ChangeLogItem changeLog) {
        if (!changeLog.isSystem()) {
            throw new MongockException("Invalid system ChangeUnit[%s]. It needs to be annotated with @%s", new Object[]{changeLog.getId(), SystemChange.class.getSimpleName()});
        }
    }
}

