/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cbeffutil.impl;

import io.mosip.kernel.cbeffutil.container.impl.CbeffContainerImpl;
import io.mosip.kernel.core.cbeffutil.common.CbeffValidator;
import io.mosip.kernel.core.cbeffutil.entity.BIR;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BIRType;
import io.mosip.kernel.core.cbeffutil.spi.CbeffUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CbeffImpl
implements CbeffUtil {
    @Value(value="${mosip.kernel.xsdstorage-uri}")
    private String configServerFileStorageURL;
    @Value(value="${mosip.kernel.xsdfile}")
    private String schemaName;
    private byte[] xsd;

    @PostConstruct
    public void loadXSD() throws IOException {
        try (InputStream xsdBytes = new URL(this.configServerFileStorageURL + this.schemaName).openStream();){
            this.xsd = IOUtils.toByteArray((InputStream)xsdBytes);
        }
    }

    public byte[] createXML(List<BIR> birList) throws Exception {
        CbeffContainerImpl cbeffContainer = new CbeffContainerImpl();
        BIRType bir = cbeffContainer.createBIRType(birList);
        return CbeffValidator.createXMLBytes((BIRType)bir, (byte[])this.xsd);
    }

    public byte[] createXML(List<BIR> birList, byte[] xsd) throws Exception {
        CbeffContainerImpl cbeffContainer = new CbeffContainerImpl();
        BIRType bir = cbeffContainer.createBIRType(birList);
        return CbeffValidator.createXMLBytes((BIRType)bir, (byte[])xsd);
    }

    public byte[] updateXML(List<BIR> birList, byte[] fileBytes) throws Exception {
        CbeffContainerImpl cbeffContainer = new CbeffContainerImpl();
        BIRType bir = cbeffContainer.updateBIRType(birList, fileBytes);
        return CbeffValidator.createXMLBytes((BIRType)bir, (byte[])this.xsd);
    }

    public boolean validateXML(byte[] xmlBytes, byte[] xsdBytes) throws Exception {
        CbeffContainerImpl cbeffContainer = new CbeffContainerImpl();
        return cbeffContainer.validateXML(xmlBytes, xsdBytes);
    }

    public boolean validateXML(byte[] xmlBytes) throws Exception {
        return this.validateXML(xmlBytes, this.xsd);
    }

    public Map<String, String> getBDBBasedOnType(byte[] fileBytes, String type, String subType) throws Exception {
        BIRType bir = CbeffValidator.getBIRFromXML((byte[])fileBytes);
        return CbeffValidator.getBDBBasedOnTypeAndSubType((BIRType)bir, (String)type, (String)subType);
    }

    public List<BIRType> getBIRDataFromXML(byte[] xmlBytes) throws Exception {
        BIRType bir = CbeffValidator.getBIRFromXML((byte[])xmlBytes);
        return bir.getBIR();
    }

    public Map<String, String> getAllBDBData(byte[] xmlBytes, String type, String subType) throws Exception {
        BIRType bir = CbeffValidator.getBIRFromXML((byte[])xmlBytes);
        return CbeffValidator.getAllBDBData((BIRType)bir, (String)type, (String)subType);
    }

    public List<BIR> convertBIRTypeToBIR(List<BIRType> birType) {
        return CbeffValidator.convertBIRTypeToBIR(birType);
    }

    public List<BIRType> getBIRDataFromXMLType(byte[] xmlBytes, String type) throws Exception {
        return CbeffValidator.getBIRDataFromXMLType((byte[])xmlBytes, (String)type);
    }
}

