/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.KeyValueManagement;
import io.nats.client.KeyValueOptions;
import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.KeyValueStatus;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamManagement;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NatsKeyValueManagement
implements KeyValueManagement {
    private final JetStreamManagement jsm;

    NatsKeyValueManagement(NatsConnection connection, KeyValueOptions kvo) throws IOException {
        this.jsm = new NatsJetStreamManagement(connection, kvo == null ? null : kvo.getJetStreamOptions());
    }

    @Override
    public KeyValueStatus create(KeyValueConfiguration config) throws IOException, JetStreamApiException {
        return new KeyValueStatus(this.jsm.addStream(config.getBackingConfig()));
    }

    @Override
    public List<String> getBucketNames() throws IOException, JetStreamApiException, InterruptedException {
        ArrayList<String> buckets = new ArrayList<String>();
        List<String> names = this.jsm.getStreamNames();
        for (String name : names) {
            if (!name.startsWith("KV_")) continue;
            buckets.add(NatsKeyValueUtil.extractBucketName(name));
        }
        return buckets;
    }

    @Override
    public KeyValueStatus getBucketInfo(String bucketName) throws IOException, JetStreamApiException {
        Validator.validateKvBucketNameRequired(bucketName);
        return new KeyValueStatus(this.jsm.getStreamInfo(NatsKeyValueUtil.toStreamName(bucketName)));
    }

    @Override
    public void delete(String bucketName) throws IOException, JetStreamApiException {
        Validator.validateKvBucketNameRequired(bucketName);
        this.jsm.deleteStream(NatsKeyValueUtil.toStreamName(bucketName));
    }
}

