/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;

class OrderedManager
extends MessageManager {
    private final NatsJetStream js;
    private final NatsDispatcher dispatcher;
    private final String stream;
    private final ConsumerConfiguration serverCC;
    private long lastStreamSeq;
    private long expectedConsumerSeq;

    OrderedManager(NatsJetStream js, NatsDispatcher dispatcher, String stream, ConsumerConfiguration serverCC) {
        this.js = js;
        this.dispatcher = dispatcher;
        this.stream = stream;
        this.serverCC = serverCC;
        this.lastStreamSeq = -1L;
        this.expectedConsumerSeq = 1L;
    }

    @Override
    boolean manage(Message msg) {
        if (msg != null) {
            long receivedConsumerSeq = msg.metaData().consumerSequence();
            if (this.expectedConsumerSeq != receivedConsumerSeq) {
                block4: {
                    try {
                        this.expectedConsumerSeq = 1L;
                        String newDeliver = this.sub.connection.createInbox();
                        ConsumerConfiguration userCC = ConsumerConfiguration.builder(this.serverCC).deliverPolicy(DeliverPolicy.ByStartSequence).deliverSubject(newDeliver).startSequence(this.lastStreamSeq + 1L).startTime(null).build();
                        this.js._createConsumer(this.stream, userCC);
                        this.sub.reSubscribe(newDeliver);
                    }
                    catch (Exception e) {
                        IllegalStateException ise = new IllegalStateException("Ordered subscription fatal error.", e);
                        this.js.conn.processException(ise);
                        if (this.dispatcher != null) break block4;
                        throw ise;
                    }
                }
                return true;
            }
            this.lastStreamSeq = msg.metaData().streamSequence();
            ++this.expectedConsumerSeq;
        }
        return false;
    }
}

