/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import java.time.ZonedDateTime;

public class MessageGetRequest
implements JsonSerializable {
    private final long sequence;
    private final String lastBySubject;
    private final String nextBySubject;
    private final ZonedDateTime startTime;

    public static MessageGetRequest forSequence(long sequence) {
        return new MessageGetRequest(sequence, null, null, null);
    }

    public static MessageGetRequest lastForSubject(String subject) {
        return new MessageGetRequest(-1L, subject, null, null);
    }

    public static MessageGetRequest firstForSubject(String subject) {
        return new MessageGetRequest(-1L, null, subject, null);
    }

    public static MessageGetRequest firstForStartTime(ZonedDateTime startTime) {
        return new MessageGetRequest(-1L, null, null, startTime);
    }

    public static MessageGetRequest firstForStartTimeAndSubject(ZonedDateTime startTime, String subject) {
        return new MessageGetRequest(-1L, null, subject, startTime);
    }

    public static MessageGetRequest nextForSubject(long sequence, String subject) {
        return new MessageGetRequest(sequence, null, subject, null);
    }

    private MessageGetRequest(long sequence, String lastBySubject, String nextBySubject, ZonedDateTime startTime) {
        this.sequence = sequence;
        this.lastBySubject = lastBySubject;
        this.nextBySubject = nextBySubject;
        this.startTime = startTime;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getLastBySubject() {
        return this.lastBySubject;
    }

    public String getNextBySubject() {
        return this.nextBySubject;
    }

    public boolean isSequenceOnly() {
        return this.sequence > 0L && this.nextBySubject == null;
    }

    public boolean isLastBySubject() {
        return this.lastBySubject != null;
    }

    public boolean isNextBySubject() {
        return this.nextBySubject != null;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "seq", this.sequence);
        JsonUtils.addField(sb, "last_by_subj", this.lastBySubject);
        JsonUtils.addField(sb, "next_by_subj", this.nextBySubject);
        JsonUtils.addField(sb, "start_time", this.startTime);
        return JsonUtils.endJson(sb).toString();
    }

    @Deprecated
    public static byte[] seqBytes(long sequence) {
        return MessageGetRequest.forSequence(sequence).serialize();
    }

    @Deprecated
    public static byte[] lastBySubjectBytes(String subject) {
        return MessageGetRequest.lastForSubject(subject).serialize();
    }

    @Deprecated
    public MessageGetRequest(long sequence) {
        this(sequence, null, null, null);
    }

    @Deprecated
    public MessageGetRequest(String lastBySubject) {
        this(-1L, lastBySubject, null, null);
    }
}

