/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Error;
import io.nats.client.api.External;
import io.nats.client.api.SubjectTransform;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.util.List;

abstract class SourceInfoBase {
    protected JsonValue jv;
    protected final String name;
    protected final long lag;
    protected final Duration active;
    protected final External external;
    protected final List<SubjectTransform> subjectTransforms;
    protected final Error error;

    SourceInfoBase(JsonValue vSourceInfo) {
        this.jv = vSourceInfo;
        this.name = JsonValueUtils.readString(vSourceInfo, "name");
        this.lag = JsonValueUtils.readLong(vSourceInfo, "lag", 0L);
        this.active = JsonValueUtils.readNanos(vSourceInfo, "active", Duration.ZERO);
        this.external = External.optionalInstance(JsonValueUtils.readValue(vSourceInfo, "external"));
        this.subjectTransforms = SubjectTransform.optionalListOf(JsonValueUtils.readValue(vSourceInfo, "subject_transforms"));
        this.error = Error.optionalInstance(JsonValueUtils.readValue(vSourceInfo, "error"));
    }

    public String getName() {
        return this.name;
    }

    public long getLag() {
        return this.lag;
    }

    public Duration getActive() {
        return this.active;
    }

    public External getExternal() {
        return this.external;
    }

    public List<SubjectTransform> getSubjectTransforms() {
        return this.subjectTransforms;
    }

    public Error getError() {
        return this.error;
    }
}

