/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Token;
import java.util.HashMap;
import java.util.Map;

public class Status {
    public static final String FLOW_CONTROL_TEXT = "FlowControl Request";
    public static final String HEARTBEAT_TEXT = "Idle Heartbeat";
    public static final String NO_RESPONDERS_TEXT = "No Responders Available For Request";
    public static final String EOB_TEXT = "EOB";
    public static final int FLOW_OR_HEARTBEAT_STATUS_CODE = 100;
    public static final int NO_RESPONDERS_CODE = 503;
    public static final int BAD_REQUEST_CODE = 400;
    public static final int NOT_FOUND_CODE = 404;
    public static final int BAD_JS_REQUEST_CODE = 408;
    public static final int REQUEST_TIMEOUT_CODE = 408;
    public static final int CONFLICT_CODE = 409;
    public static final int EOB_CODE = 204;
    public static String BAD_REQUEST = "Bad Request";
    public static String NO_MESSAGES = "No Messages";
    public static String CONSUMER_DELETED = "Consumer Deleted";
    public static String CONSUMER_IS_PUSH_BASED = "Consumer is push based";
    public static String MESSAGE_SIZE_EXCEEDS_MAX_BYTES = "Message Size Exceeds MaxBytes";
    public static String EXCEEDED_MAX_WAITING = "Exceeded MaxWaiting";
    public static String EXCEEDED_MAX_REQUEST_BATCH = "Exceeded MaxRequestBatch";
    public static String EXCEEDED_MAX_REQUEST_EXPIRES = "Exceeded MaxRequestExpires";
    public static String EXCEEDED_MAX_REQUEST_MAX_BYTES = "Exceeded MaxRequestMaxBytes";
    public static String BATCH_COMPLETED = "Batch Completed";
    public static String SERVER_SHUTDOWN = "Server Shutdown";
    public static String LEADERSHIP_CHANGE = "Leadership Change";
    public static final Status EOB = new Status(204, "EOB");
    public static final Status TIMEOUT_OR_NO_MESSAGES = new Status(404, "Timeout or No Messages");
    private final int code;
    private final String message;
    private static final Map<Integer, String> CODE_TO_TEXT = new HashMap<Integer, String>();

    public Status(int code, String message) {
        this.code = code;
        this.message = message == null ? this.makeMessage(code) : message;
    }

    public Status(Token codeToken, Token messageToken) {
        this(Status.extractCode(codeToken), Status.extractMessage(messageToken));
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithCode() {
        return this.code + " " + this.message;
    }

    private static String extractMessage(Token messageToken) {
        return messageToken.hasValue() ? messageToken.getValue() : null;
    }

    private static int extractCode(Token codeToken) {
        try {
            return Integer.parseInt(codeToken.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid header status code");
        }
    }

    private String makeMessage(int code) {
        String message = CODE_TO_TEXT.get(code);
        return message == null ? "Server Status Message: " + code : message;
    }

    public String toString() {
        return "Status{code=" + this.code + ", message='" + this.message + '\'' + '}';
    }

    public boolean isFlowControl() {
        return this.code == 100 && this.message.equals(FLOW_CONTROL_TEXT);
    }

    public boolean isHeartbeat() {
        return this.code == 100 && this.message.equals(HEARTBEAT_TEXT);
    }

    public boolean isNoResponders() {
        return this.code == 503 && this.message.equals(NO_RESPONDERS_TEXT);
    }

    public boolean isEob() {
        return this.code == 204 && this.message.equals(EOB_TEXT);
    }

    static {
        CODE_TO_TEXT.put(503, NO_RESPONDERS_TEXT);
    }
}

