/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.Validator;
import java.util.Objects;

public class Group {
    private final String name;
    private Group next;

    public Group(String name) {
        name = Validator.emptyAsNull(name);
        if (name == null) {
            throw new IllegalArgumentException("Group name cannot be null or empty.");
        }
        if (name.contains(">")) {
            throw new IllegalArgumentException("Group name cannot contain '>'.");
        }
        this.name = Validator.validateSubjectTerm(name, "Group name", false);
    }

    public Group appendGroup(Group group) {
        Group last = this;
        while (last.next != null) {
            last = last.next;
        }
        last.next = group;
        return this;
    }

    public String getSubject() {
        return this.next == null ? this.name : this.name + "." + this.next.getSubject();
    }

    public String getName() {
        return this.name;
    }

    public Group getNext() {
        return this.next;
    }

    public String toString() {
        return "Group [" + this.getSubject().replace('.', '/') + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (!Objects.equals(this.name, group.name)) {
            return false;
        }
        return Objects.equals(this.next, group.next);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }
}

