// Copyright 2020 The NATS Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at:
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package io.nats.client.api;

import io.nats.client.Message;

import static io.nats.client.support.ApiConstants.SUCCESS;
import static io.nats.client.support.JsonValueUtils.readBoolean;

/**
 * A response indicating a successful api call
 */
public class SuccessApiResponse extends ApiResponse<SuccessApiResponse> {
    boolean success;

    /**
     * Construct a SuccessApiResponse from a message
     * @param msg the message
     */
    public SuccessApiResponse(Message msg) {
        super(msg);
        Boolean b = readBoolean(jv, SUCCESS, null);
        if (b == null) {
            success = !hasError();
        }
        else {
            success = b;
        }
    }

    /**
     * Get the success state
     * @return true if the call was successful
     */
    public boolean getSuccess() {
        return success;
    }
}
