/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher;

import io.nessus.utils.AssertArgument;
import io.nessus.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCipher {
    private final SecureRandom secureRandom = new SecureRandom();

    public SecretKey getSecretKey() {
        byte[] key = new byte[16];
        this.secureRandom.nextBytes(key);
        return new SecretKeySpec(key, "AES");
    }

    public String encodeSecretKey(SecretKey secKey) {
        byte[] raw = secKey.getEncoded();
        return Base64.getEncoder().encodeToString(raw);
    }

    public SecretKey decodeSecretKey(String encodedForm) {
        byte[] raw = Base64.getDecoder().decode(encodedForm);
        AssertArgument.assertTrue((Boolean)(raw.length == 16 ? 1 : 0), (String)"Expected 128 bit");
        return new SecretKeySpec(raw, "AES");
    }

    public InputStream encrypt(SecretKey secKey, InputStream ins) throws IOException, GeneralSecurityException {
        return this.encrypt(secKey, null, ins);
    }

    public InputStream encrypt(SecretKey secKey, byte[] addData, InputStream ins) throws IOException, GeneralSecurityException {
        byte[] iv = new byte[12];
        this.secureRandom.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secKey, parameterSpec);
        if (addData != null) {
            cipher.updateAAD(addData);
        }
        CipherInputStream cis = new CipherInputStream(ins, cipher);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)cis, (OutputStream)baos);
        byte[] cipherText = baos.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + cipherText.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(cipherText);
        byte[] result = byteBuffer.array();
        return new ByteArrayInputStream(result);
    }

    public InputStream decrypt(SecretKey secKey, InputStream secretStream) throws IOException, GeneralSecurityException {
        return this.decrypt(secKey, null, secretStream);
    }

    public InputStream decrypt(SecretKey secKey, byte[] addData, InputStream secretStream) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)secretStream, (OutputStream)baos);
        byte[] secretMessage = baos.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(secretMessage);
        int ivLength = byteBuffer.getInt();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)secKey, new GCMParameterSpec(128, iv));
        if (addData != null) {
            cipher.updateAAD(addData);
        }
        ByteArrayInputStream ins = new ByteArrayInputStream(cipherText);
        CipherInputStream cis = new CipherInputStream(ins, cipher);
        baos = new ByteArrayOutputStream();
        StreamUtils.copyStream((InputStream)cis, (OutputStream)baos);
        byte[] result = baos.toByteArray();
        return new ByteArrayInputStream(result);
    }
}

