/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cipher;

import io.nessus.cipher.AESCipher;
import io.nessus.cipher.ECIESCipher;
import io.nessus.utils.AssertState;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public class CipherSanityCheck {
    public static void main(String[] args) throws Exception {
        CipherSanityCheck.verifyPlatform();
    }

    public static void verifyPlatform() throws GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        AESCipher aes = new AESCipher();
        byte[] encBytes = aes.getSecretKey().getEncoded();
        String encSecret = Base64.getEncoder().encodeToString(encBytes);
        String privKey = "cVfiZLCWbCm3SWoBAToaCoMuYJJjEw5cR6ifuWQY1a5wadXynGC2";
        byte[] seed = Arrays.reverse((byte[])privKey.getBytes());
        ECIESCipher ecies = new ECIESCipher();
        KeyPair keyPair = ecies.generateKeyPair(seed);
        PublicKey pubKey = keyPair.getPublic();
        PrivateKey pivKey = keyPair.getPrivate();
        final String encPubKey = Base64.getEncoder().encodeToString(pubKey.getEncoded());
        AssertState.assertEquals((Object)"MDYwEAYHKoZIzj0CAQYFK4EEABwDIgAEoQu96WAI2FFlR+6F5AEkvomjkHSPHo4owSut2em3FP8=", (Object)encPubKey);
        AssertState.assertEquals((Object)56, (Object)pubKey.getEncoded().length);
        pubKey = new PublicKey(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getFormat() {
                return "X.509";
            }

            @Override
            public byte[] getEncoded() {
                return Base64.getDecoder().decode(encPubKey);
            }

            @Override
            public String getAlgorithm() {
                return "EC";
            }
        };
        byte[] ciphertext = ecies.encrypt(pubKey, encBytes);
        byte[] decrypted = ecies.decrypt(pivKey, ciphertext);
        String encResult = Base64.getEncoder().encodeToString(decrypted);
        AssertState.assertEquals((Object)encSecret, (Object)encResult);
    }
}

