/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.nessus.Wallet;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public class FHandle {
    final Wallet.Address owner;
    final String cid;
    final Path path;
    final URL furl;
    final String txId;
    final String secToken;
    final boolean available;
    final boolean expired;
    final int attempt;
    final Long elapsed;
    final AtomicBoolean scheduled;

    private FHandle(String cid, Path path, Wallet.Address owner, URL furl, String secToken, String txId, boolean available, boolean expired, AtomicBoolean scheduled, int attempt, Long elapsed) {
        this.owner = owner;
        this.path = path;
        this.furl = furl;
        this.cid = cid;
        this.txId = txId;
        this.secToken = secToken;
        this.available = available;
        this.expired = expired;
        this.scheduled = scheduled;
        this.attempt = attempt;
        this.elapsed = elapsed;
    }

    public String getCid() {
        return this.cid;
    }

    public URL getURL() {
        return this.furl;
    }

    public Path getPath() {
        return this.path;
    }

    public Wallet.Address getOwner() {
        return this.owner;
    }

    public String getTxId() {
        return this.txId;
    }

    public String getSecretToken() {
        return this.secToken;
    }

    public boolean isEncrypted() {
        return this.secToken != null;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean setScheduled(boolean flag) {
        return this.scheduled.compareAndSet(!flag, flag);
    }

    public boolean isScheduled() {
        return this.scheduled.get();
    }

    public int getAttempt() {
        return this.attempt;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public boolean isMissing() {
        return !this.available && !this.expired;
    }

    public String toString() {
        return String.format("[cid=%s, owner=%s, path=%s, avl=%d, exp=%d, try=%d, time=%s]", this.cid, this.owner.getAddress(), this.path, this.available ? 1 : 0, this.expired ? 1 : 0, this.attempt, this.elapsed);
    }

    public static class FHBuilder {
        private Wallet.Address owner;
        private String cid;
        private Path path;
        private URL furl;
        private String txId;
        private String secToken;
        private boolean available;
        private boolean expired;
        private int attempt;
        private Long elapsed;
        private AtomicBoolean scheduled = new AtomicBoolean();

        public FHBuilder(FHandle fhandle) {
            this.owner = fhandle.owner;
            this.cid = fhandle.cid;
            this.path = fhandle.path;
            this.furl = fhandle.furl;
            this.txId = fhandle.txId;
            this.secToken = fhandle.secToken;
            this.available = fhandle.available;
            this.expired = fhandle.expired;
            this.scheduled = fhandle.scheduled;
            this.attempt = fhandle.attempt;
            this.elapsed = fhandle.elapsed;
        }

        public FHBuilder(URL furl) {
            this.furl = furl;
        }

        public FHBuilder(String cid) {
            this.cid = cid;
        }

        public FHBuilder cid(String cid) {
            this.cid = cid;
            return this;
        }

        public FHBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public FHBuilder owner(Wallet.Address owner) {
            this.owner = owner;
            return this;
        }

        public FHBuilder url(URL furl) {
            this.furl = furl;
            return this;
        }

        public FHBuilder secretToken(String secToken) {
            this.secToken = secToken;
            return this;
        }

        public FHBuilder txId(String txId) {
            this.txId = txId;
            return this;
        }

        public FHBuilder available(boolean available) {
            this.available = available;
            return this;
        }

        public FHBuilder expired(boolean expired) {
            this.expired = expired;
            return this;
        }

        public FHBuilder attempt(int attempt) {
            this.attempt = attempt;
            return this;
        }

        public FHBuilder elapsed(long millis) {
            this.elapsed = this.elapsed != null ? this.elapsed + millis : millis;
            return this;
        }

        public FHandle build() {
            return new FHandle(this.cid, this.path, this.owner, this.furl, this.secToken, this.txId, this.available, this.expired, this.scheduled, this.attempt, this.elapsed);
        }
    }
}

