/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;

public class DefaultFullBinaryMemcacheRequest
extends DefaultBinaryMemcacheRequest
implements FullBinaryMemcacheRequest {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheRequest(String key, ByteBuf extras) {
        this(key, extras, Unpooled.buffer((int)0));
    }

    public DefaultFullBinaryMemcacheRequest(String key, ByteBuf extras, ByteBuf content) {
        super(key, extras);
        if (content == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = content;
    }

    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullBinaryMemcacheRequest retain() {
        super.retain();
        this.content.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest retain(int increment) {
        super.retain(increment);
        this.content.retain(increment);
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch() {
        super.touch();
        this.content.touch();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest touch(Object hint) {
        super.touch(hint);
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        super.release();
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        super.release(decrement);
        return this.content.release(decrement);
    }

    @Override
    public FullBinaryMemcacheRequest copy() {
        ByteBuf extras = this.extras();
        if (extras != null) {
            extras = extras.copy();
        }
        return new DefaultFullBinaryMemcacheRequest(this.key(), extras, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheRequest duplicate() {
        ByteBuf extras = this.extras();
        if (extras != null) {
            extras = extras.duplicate();
        }
        return new DefaultFullBinaryMemcacheRequest(this.key(), extras, this.content().duplicate());
    }
}

