/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultAttributeMap
implements AttributeMap {
    private Map<AttributeKey<?>, Attribute<?>> map;

    @Override
    public synchronized <T> Attribute<T> attr(AttributeKey<T> key) {
        Attribute<?> attr;
        Map<AttributeKey<?>, Attribute<?>> map = this.map;
        if (map == null) {
            this.map = new IdentityHashMap(2);
            map = this.map;
        }
        if ((attr = map.get(key)) == null) {
            attr = new DefaultAttribute();
            map.put(key, attr);
        }
        return attr;
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final long serialVersionUID = -2661411462200283011L;

        private DefaultAttribute() {
        }

        @Override
        public T setIfAbsent(T value) {
            while (!this.compareAndSet(null, value)) {
                Object old = this.get();
                if (old == null) continue;
                return (T)old;
            }
            return null;
        }

        @Override
        public void remove() {
            this.set(null);
        }
    }
}

