/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.sslserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.http.websocketx.sslserver.WebSocketSslServerInitializer;
import io.netty.util.internal.SystemPropertyUtil;

public class WebSocketSslServer {
    private final int port;

    public WebSocketSslServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketSslServerInitializer());
            Channel ch = b.bind(this.port).sync().channel();
            System.out.println("Web socket server started at port " + this.port + '.');
            System.out.println("Open your browser and navigate to https://localhost:" + this.port + '/');
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        String keyStoreFilePassword;
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8443;
        String keyStoreFilePath = SystemPropertyUtil.get((String)"keystore.file.path");
        if (keyStoreFilePath == null || keyStoreFilePath.isEmpty()) {
            System.out.println("ERROR: System property keystore.file.path not set. Exiting now!");
            System.exit(1);
        }
        if ((keyStoreFilePassword = SystemPropertyUtil.get((String)"keystore.file.password")) == null || keyStoreFilePassword.isEmpty()) {
            System.out.println("ERROR: System property keystore.file.password not set. Exiting now!");
            System.exit(1);
        }
        new WebSocketSslServer(port).run();
    }
}

